<?php

namespace Config;
use CodeIgniter\Router\RouteCollection;

//🚫    Create a new instance of our RouteCollection class.
        $routes = Services::routes();
// -----------------------------------------------------------------------

//⚠️    Router Setup
        $routes->setDefaultNamespace('App\Controllers');
        $routes->setDefaultController('Home');
        $routes->setDefaultMethod('index');
        $routes->setTranslateURIDashes(false);
        $routes->set404Override();
// -----------------------------------------------------------------------

// ===================================================
// 🗂️ ROUTES ADMIN - MENU UTAMA             // ✅ Base URL: http://localhost/qr-admin-2026/
// ===================================================

    // 🗂️ DASHBOARD UTAMA

        // ----------------------
        // 🛑 MENU UTAMA DASHBOARD
        // ----------------------
                 //Dashboard
                    $routes->get('/', 'Admin\Dashboard::index');                    
                    $routes->get('dashboard', 'Admin\Dashboard:index');
                    // ✅ Base URL: http://localhost/qr-admin-2026/
                    // Url: admin/dashboard

        // ----------------------
        // 🛑 MENU 2 - QR CODE
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menuqrcode', 'Admin\MenuQrCode::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menuqrcode
                    // Url: admin/menuqrcode
                });

                // ⚙️ Sub Menu
                    // 🗂️📛 ABSENSI SISWA (MANUAL)             // URL : http://localhost/qr-admin-2026/admin/absen-siswa
                            // admin/absen-siswa
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // admin lihat data absen siswa
                                $routes->get('absen-siswa', 'Admin\DataAbsenSiswa::index');

                                // ambil siswa berdasarkan kelas dan tanggal
                                $routes->post('absen-siswa', 'Admin\DataAbsenSiswa::ambilDataSiswa');

                                // ambil kehadiran siswa
                                $routes->post('absen-siswa/kehadiran', 'Admin\DataAbsenSiswa::ambilKehadiran');

                                // ubah kehadiran siswa
                                $routes->post('absen-siswa/edit', 'Admin\DataAbsenSiswa::ubahKehadiran');

                            });

                // ⚙️ Sub Menu
                    // 🗂️📛 SCAN - akses menggunakan filter role
                                    //scan/masuk
                                    // scan/duhur
                                    // scan/pulang
                                    // http://localhost/qr-admin-2026/scan/masuk
                                    // http://localhost/qr-admin-2026/scan/duhur
                                    // http://localhost/qr-admin-2026/scan/pulang
                            $routes->group('scan', ['filter' => 'role'], function($routes) {

                                // Halaman utama scan default
                                $routes->get('', 'Scan::index');                // /scan

                                // Presensi spesifik
                                $routes->get('masuk', 'Scan::index/Masuk');     // /scan/masuk
                                $routes->get('pulang', 'Scan::index/Pulang');   // /scan/pulang
                                $routes->get('duhur', 'Scan::index/Duhur');     // /scan/duhur

                                // Presensi POST
                                $routes->post('cek', 'Scan::cekKode');         // /scan/cek

                            });

                // ⚙️ Sub Menu
                    // 🗂️ SCAN IZIN          
                                    //scan/izin
                                    // http://localhost/qr-admin-2026/scan/izin
                                $routes->get('scan', 'Scan::index');
                                $routes->get('scan/(:any)', 'Scan::index/$1');
                                $routes->post('scan/cek', 'Scan::cekKode');

                                $routes->get('scan/izin', 'Scan::izin');                         
                                $routes->post('scan/cek-izin', 'Scan::cekIzin');
                                $routes->post('scan/simpan-izin', 'Scan::simpanIzin');
                            // -------------------------------------------------
                //----------------------------------------------

        // ----------------------
        // 🛑 MENU 3 - PIKET IZIN
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menupiket', 'Admin\MenuPiket::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menupiket
                    // Url  : admin/menupiket
                });

                // ⚙️ Sub Menu
                    // 🚀 ROUTES ADMIN - PIKET IZIN
                        // Base URL: http://localhost/qr-admin-2026/admin/piket
                        $routes->group('admin', ['filter' => 'role'], function ($routes) {

                            $routes->group('piket', function ($routes) {

                                // ----------------------
                                // 🔹 HALAMAN IZIN SISWA
                                // ----------------------
                                $routes->get('suratizin', 'Admin\Piket\SuratIzinController::index');           
                                // ✅ http://localhost/qr-admin-2026/admin/piket/suratizin

                                $routes->post('suratizin/simpan', 'Admin\Piket\SuratIzinController::simpan');  
                                // ✅ http://localhost/qr-admin-2026/admin/piket/suratizin/simpan

                                $routes->get('suratizin/setujui/(:num)', 'Admin\Piket\SuratIzinController::setujui/$1'); 
                                // ✅ http://localhost/qr-admin-2026/admin/piket/suratizin/setujui/{id}

                                // ----------------------
                                // 🔹 CETAK SURAT IZIN
                                // ----------------------
                                $routes->get('suratizin/cetak/(:num)', 'Admin\Piket\CetakLaporan::index/$1'); 
                                // ✅ http://localhost/qr-admin-2026/admin/piket/suratizin/cetak/{id}

                                // ----------------------
                                // 🔹 REKAP IZIN SISWA
                                // ----------------------
                                $routes->get('rekapizinsiswa', 'Admin\Piket\RekapIzinSiswa::index');          
                                // ✅ http://localhost/qr-admin-2026/admin/piket/rekapizinsiswa

                                $routes->get('rekapizinsiswa/exportCSV', 'Admin\Piket\RekapIzinSiswa::exportCSV'); 
                                // ✅ http://localhost/qr-admin-2026/admin/piket/rekapizinsiswa/exportCSV

                            });

                        });

                // ⚙️ Sub Menu
                    // 🚀 ROUTES ADMIN - CATATAN PELANGGARAN SISWA
                            // Base URL: http://localhost/qr-admin-2026/admin/pelanggaran
                            $routes->group('admin/pelanggaran', ['filter' => 'role'], function($routes) {

                                // ----------------------
                                // 🔹 HALAMAN UTAMA
                                // ----------------------
                                $routes->get('/', 'Admin\Pelanggaran\PelanggaranSiswaController::index'); 
                                // ✅ http://localhost/qr-admin-2026/admin/pelanggaran

                                // ----------------------
                                // 🔹 TAMBAH DATA PELANGGARAN
                                // ----------------------
                                $routes->get('tambah', 'Admin\Pelanggaran\PelanggaranSiswaController::tambah'); 
                                // ✅ http://localhost/qr-admin-2026/admin/pelanggaran/tambah

                                $routes->post('simpan', 'Admin\Pelanggaran\PelanggaranSiswaController::simpan'); 
                                // ✅ http://localhost/qr-admin-2026/admin/pelanggaran/simpan

                                // ----------------------
                                // 🔹 AJAX
                                // ----------------------
                                $routes->get('ajax/siswa/(:num)', 'Admin\Pelanggaran\PelanggaranAjaxController::siswaByKelas/$1'); 
                                // ✅ http://localhost/qr-admin-2026/admin/pelanggaran/ajax/siswa/{id_kelas}

                                // ----------------------
                                // 🔹 REKAP PELANGGARAN
                                // ----------------------
                                $routes->get('rekap', 'Admin\Pelanggaran\RekapController::index'); 
                                // ✅ http://localhost/qr-admin-2026/admin/pelanggaran/rekap

                            });
                //----------------------------------------------

        // ----------------------
        // 🛑 MENU 4 - DATA
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menudata', 'Admin\MenuData::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menudata
                    // URL : admin/menudata
                });

                // ⚙️ Sub Menu
                    // 🗂️ EDIT UTAMA SATA SISWA | URL : http://localhost/qr-admin-2026/admin/siswa
                            // admin/siswa
                            // ==========================
                            // 🚀 ROUTES ADMIN - DATA SISWA
                            // Base URL: http://localhost/qr-admin-2026/admin/siswa
                            // ==========================
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // ----------------------
                                // 🔹 LIHAT DATA SISWA
                                // ----------------------
                                $routes->get('siswa', 'Admin\DataSiswa2::index');             // halaman utama data siswa
                                $routes->post('siswa', 'Admin\DataSiswa2::ambilDataSiswa');  // ambil data via AJAX
                                $routes->post('siswa/ambilDataSiswa', 'Admin\DataSiswa2::ambilDataSiswa');

                                // ----------------------
                                // 🔹 TAMBAH DATA SISWA
                                // ----------------------
                                $routes->get('siswa/create', 'Admin\DataSiswa2::formTambahSiswa');  // form tambah siswa
                                $routes->post('siswa/create', 'Admin\DataSiswa2::saveSiswa');       // simpan siswa baru

                                // ----------------------
                                // 🔹 EDIT DATA SISWA
                                // ----------------------
                                $routes->get('siswa/edit/(:any)', 'Admin\DataSiswa2::formEditSiswa/$1'); // form edit siswa
                                $routes->post('siswa/edit', 'Admin\DataSiswa2::updateSiswa');            // update via form
                                $routes->post('siswa/updateSiswa', 'Admin\DataSiswa2::updateSiswa');     // alias route
                                $routes->post('admin/siswa/updateSiswa', 'Admin\DataSiswa2::updateSiswa'); // penting untuk form action

                                // ----------------------
                                // 🔹 HAPUS DATA SISWA
                                // ----------------------
                                $routes->post('siswa/deleteSelectedSiswa', 'Admin\DataSiswa2::deleteSelectedSiswa'); // hapus banyak
                                $routes->delete('siswa/delete/(:any)', 'Admin\DataSiswa2::delete/$1');              // hapus 1 siswa (DELETE method)

                                // ----------------------
                                // 🔹 BULK / CSV
                                // ----------------------
                                $routes->get('siswa/bulk', 'Admin\DataSiswa2::bulkPostSiswa');                     // halaman bulk CSV
                                $routes->post('siswa/downloadCSVFilePost', 'Admin\DataSiswa2::downloadCSVFilePost');  // download CSV
                                $routes->post('siswa/generateCSVObjectPost', 'Admin\DataSiswa2::generateCSVObjectPost'); // generate CSV object
                                $routes->post('siswa/importCSVItemPost', 'Admin\DataSiswa2::importCSVItemPost');      // import CSV item
                            });

                // ⚙️ Sub Menu
                    // 🗂️ DATA SISWA | URL : http://localhost/qr-admin-2026/admin/upload/datasiswa
                            // admin/upload/datasiswa
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                $routes->get('upload/datasiswa', 'Admin\Upload\DataSiswa::index');
                                $routes->post('upload/datasiswa/save', 'Admin\Upload\DataSiswa::save');
                                $routes->get('upload/datasiswa/edit/(:num)', 'Admin\Upload\DataSiswa::edit/$1');
                                $routes->post('upload/datasiswa/update/(:num)', 'Admin\Upload\DataSiswa::update/$1');
                                $routes->get('upload/datasiswa/delete/(:num)', 'Admin\Upload\DataSiswa::delete/$1');

                            });

                // ⚙️ Sub Menu
                    // 🗂️ INPUT JURUSAN | URL : http://localhost/qr-admin-2026/admin/upload/input-jurusan
                            // admin/upload/input-jurusan
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                $routes->get('upload/input-jurusan', 'Admin\Upload\InputJurusan::index');
                                $routes->post('upload/input-jurusan/store', 'Admin\Upload\InputJurusan::store');
                                $routes->post('upload/input-jurusan/update/(:num)', 'Admin\Upload\InputJurusan::update/$1');
                                $routes->get('upload/input-jurusan/delete/(:num)', 'Admin\Upload\InputJurusan::delete/$1');

                            });

                // ⚙️ Sub Menu
                    // 🗂️ INPUT KELAS | URL : http://localhost/qr-admin-2026/admin/upload/kelas
                            // admin/upload/kelas
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                $routes->get('upload/kelas', 'Admin\Upload\InputKelas::index');
                                $routes->post('upload/kelas/store', 'Admin\Upload\InputKelas::store');
                                $routes->post('upload/kelas/update/(:num)', 'Admin\Upload\InputKelas::update/$1');
                                $routes->post('upload/kelas/delete/(:num)', 'Admin\Upload\InputKelas::delete/$1');

                            });

                // ⚙️ Sub Menu
                    // 🗂️ INPUT SISWA MANUAL | URL : http://localhost/qr-admin-2026/admin/upload/input_siswa
                            // admin/upload/input_siswa
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                $routes->get('upload/input_siswa', 'Admin\Upload\InputSiswa::index');
                                $routes->post('upload/input_siswa/save', 'Admin\Upload\InputSiswa::save');
                                $routes->get('upload/input_siswa/edit/(:num)', 'Admin\Upload\InputSiswa::edit/$1');
                                $routes->post('upload/input_siswa/update/(:num)', 'Admin\Upload\InputSiswa::update/$1');
                                $routes->get('upload/input_siswa/delete/(:num)', 'Admin\Upload\InputSiswa::delete/$1');

                            });

                // ⚙️ Sub Menu
                    // 🗂️ UPLOAD SISWA | URL : http://localhost/qr-admin-2026/admin/upload/siswa
                            // admin/upload/siswa
                            // $routes->group('admin', ['filter' => 'role'], function ($routes) {

                            //     $routes->get('upload/siswa', 'Admin\Upload\UploadSiswa::index');
                            //     $routes->post('upload/siswa/preview', 'Admin\Upload\UploadSiswa::preview');
                            //     $routes->post('upload/siswa/save', 'Admin\Upload\UploadSiswa::save');
                            //     $routes->get('upload/siswa/format', 'Admin\Upload\UploadSiswa::downloadFormat');

                            // });

                // ⚙️ Sub Menu
                    // 🚀 ROUTES ADMIN - GENERATE QR
                            // Base URL: http://localhost/qr-admin-2026/admin/generate
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // ----------------------
                                // 🔹 HALAMAN UTAMA
                                // ----------------------
                                $routes->get('generate', 'Admin\QrDownload\GenerateQR::index'); 
                                // ✅ http://localhost/qr-admin-2026/admin/generate

                                // ----------------------
                                // 🔹 AJAX
                                // ----------------------
                                $routes->post('generate/siswa-by-kelas', 'Admin\QrDownload\GenerateQR::getSiswaByKelas'); 
                                // ✅ http://localhost/qr-admin-2026/admin/generate/siswa-by-kelas

                                // ----------------------
                                // 🔹 GENERATE QR
                                // ----------------------
                                $routes->post('generate/siswa', 'Admin\QRGenerator::generateQrSiswa'); 
                                // ✅ http://localhost/qr-admin-2026/admin/generate/siswa

                                $routes->post('generate/guru', 'Admin\QRGenerator::generateQrGuru');   
                                // ✅ http://localhost/qr-admin-2026/admin/generate/guru

                                // ----------------------
                                // 🔹 DOWNLOAD QR
                                // ----------------------
                                // Siswa
                                $routes->get('qr/siswa/download', 'Admin\QRGenerator::downloadAllQrSiswa');           
                                // ✅ http://localhost/qr-admin-2026/admin/qr/siswa/download

                                $routes->get('qr/siswa/(:any)/download', 'Admin\QRGenerator::downloadQrSiswa/$1');    
                                // ✅ http://localhost/qr-admin-2026/admin/qr/siswa/{id}/download

                                // Guru
                                $routes->get('qr/guru/download', 'Admin\QRGenerator::downloadAllQrGuru');             
                                // ✅ http://localhost/qr-admin-2026/admin/qr/guru/download

                                $routes->get('qr/guru/(:any)/download', 'Admin\QRGenerator::downloadQrGuru/$1');      
                                // ✅ http://localhost/qr-admin-2026/admin/qr/guru/{id}/download

                            });
                //----------------------------------------------

        // ----------------------
        // 🛑 MENU 5 - LAPORAN / REKAP
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menurekap', 'Admin\MenuRekap::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menurekap
                    // URL : admin/menurekap
                });
                // ⚙️ Sub Menu
                    // ✅ ROUTES ADMIN - LAPORAN KEHADIRAN SISWA
                        // Base URL: http://localhost/qr-admin-2026/admin
                        // HARIAN / MINGGUAN / BULANAN / PERSISWA / BULANAN REVISI
                        // ===================================================

                                $routes->group('admin', ['filter' => 'role'], function($routes) {

                                    // ----------------------
                                    // 🔹 LAPORAN HARIAN & DETAIL SISWA
                                    // ----------------------
                                    $routes->group('lap', function($routes){
                                        $routes->get('lapharian', 'Admin\Lap\LapControllerHarian::index'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapharian

                                        $routes->get('lapharian/exportCSV', 'Admin\Lap\LapControllerHarian::exportCSV'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapharian/exportCSV

                                        $routes->get('detail-siswa/(:num)', 'Admin\Lap\LapControllerHarian::detailSiswa/$1'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/detail-siswa/{id}

                                        $routes->get('lapharian/exportSiswaCSVDetail', 'Admin\Lap\LapControllerHarian::exportSiswaCSVDetail'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapharian/exportSiswaCSVDetail
                                    });

                                    // ----------------------
                                    // 🔹 LAPORAN MINGGUAN
                                    // ----------------------
                                    $routes->group('lap', function($routes){
                                        $routes->get('lapmingguan', 'Admin\Lap\LapControllerMingguan::index'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapmingguan

                                        $routes->get('lapmingguan/exportCSV', 'Admin\Lap\LapControllerMingguan::exportCSV'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapmingguan/exportCSV
                                    });

                                    // ----------------------
                                    // 🔹 LAPORAN BULANAN
                                    // ----------------------
                                    $routes->group('lap', function($routes){
                                        $routes->get('lapbulanan', 'Admin\Lap\LapControllerBulanan::index'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapbulanan

                                        $routes->get('lapbulanan/exportCSV', 'Admin\Lap\LapControllerBulanan::exportCSV'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapbulanan/exportCSV
                                    });

                                    // ----------------------
                                    // 🔹 LAPORAN BULANAN REVISI (TANGGAL 1-30)
                                    // ----------------------
                                    $routes->group('lap', function($routes){
                                        $routes->get('lapbulananhadir', 'Admin\Lap\LapControllerBulananHadir::index'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/lap/lapbulananhadir
                                    });

                                    // ----------------------
                                    // 🔹 REKAP BULANAN KEHADIRAN
                                    // ----------------------
                                    $routes->group('kehadiran', function($routes){
                                        $routes->get('rekapbulanan', 'Admin\Kehadiran\RekapBulanan::rekapBulanan'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/kehadiran/rekapbulanan

                                        $routes->get('rekapbulanan/exportCSV', 'Admin\Kehadiran\RekapBulanan::exportCSV'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/kehadiran/rekapbulanan/exportCSV

                                        $routes->get('detail/(:num)', 'Admin\Kehadiran\RekapBulanan::detail/$1'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/kehadiran/detail/{id}

                                        $routes->get('exportCSVDetail', 'Admin\Kehadiran\RekapBulanan::exportCSVDetail'); 
                                        // ✅ http://localhost/qr-admin-2026/admin/kehadiran/exportCSVDetail
                                    });

                                });

        // ----------------------
        // 🛑 MENU 6 - GRAFIK / PERSENTASE
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menu-persentasi', 'Admin\MenuPersentasi::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menu-persentasi
                    // URL : admin/menu-persentasi

                    $routes->get('live-persentase', 'Admin\MenuPersentasi::livePersentase'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/live-persentase
                });
                // ⚙️ Sub Menu
                    // 🚀 ROUTES ADMIN - PERSENTASE KEHADIRAN SISWA        
                            // Base URL: http://localhost/qr-admin-2026/admin
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // ----------------------
                                // 🔹 HALAMAN UTAMA
                                // ----------------------
                                $routes->get('persentase', 'Admin\Persentase\Persentase::index'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase

                                // ----------------------
                                // 🔹 TREN KEHADIRAN HARIAN
                                // ----------------------
                                $routes->get('persentase/tren-harian', 'Admin\Persentase\Persentase::trenHarian'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/tren-harian

                                // ----------------------
                                // 🔹 PERBANDINGAN
                                // ----------------------
                                $routes->get('persentase/perbandingan-kelas', 'Admin\Persentase\Persentase::perbandinganKelas'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/perbandingan-kelas

                                $routes->get('persentase/perbandingan-sekolah', 'Admin\Persentase\Persentase::perbandinganSekolah'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/perbandingan-sekolah

                                $routes->get('persentase/perbandingan-siswa', 'Admin\Persentase\Persentase::perbandinganSiswa'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/perbandingan-siswa

                                $routes->get('persentase/perbandingan-siswa-sekolah', 'Admin\Persentase\Persentase::perbandinganSiswaSekolah'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/perbandingan-siswa-sekolah

                                // ----------------------
                                // 🔹 KELAS TERBAIK / SPESIAL
                                // ----------------------
                                $routes->get('persentase/kelas-terbaik', 'Admin\Persentase\Persentase::kelasTerbaik'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/kelas-terbaik

                                $routes->get('persentase/kelas-terbaik-solat', 'Admin\Persentase\Persentase::kelasTerbaikSolat'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/kelas-terbaik-solat

                                $routes->get('persentase/kelas-paling-telat', 'Admin\Persentase\Persentase::kelasPalingTelat'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/kelas-paling-telat

                                $routes->get('persentase/kelas-paling-alpa', 'Admin\Persentase\Persentase::kelasPalingAlpa'); 
                                // ✅ http://localhost/qr-admin-2026/admin/persentase/kelas-paling-alpa

                            });
                //----------------------------------------------

        // ----------------------
        // 🛑 MENU 7 - PENGATURAN
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menuseting', 'Admin\MenuSeting::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menuseting
                    // URL : admin/menuseting
                });
                // ⚙️ Sub Menu 1
                    // 🗂️📛 SETING ABSENSI OTOMATIs      // URL : http://localhost/qr-admin-2026/admin/absenotomatis
                        // admin/absenotomatis
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                $routes->get('absenotomatis', 'Admin\AbsenOtomatis\AbsenOtomatis::index');
                                $routes->post('absenotomatis/simpan', 'Admin\AbsenOtomatis\AbsenOtomatis::simpan');

                            });

                // ⚙️ Sub Menu 2
                    // 🗂️ ⏰ SETING JAM KEHADIRAN       // URL : http://localhost/qr-admin-2026/admin/jam-presensi
                        // admin/jam-presensi
                        $routes->group('admin', ['filter' => 'role'], function ($routes) {

                            // pengaturan jam presensi
                            $routes->group('jam-presensi', function ($routes) {

                                // tampil data jam presensi
                                // URL : /admin/jam-presensi
                                $routes->get('/', 'Admin\Jam\JamPresensi::index');

                                // form tambah jam presensi
                                // URL : /admin/jam-presensi/create
                                $routes->get('create', 'Admin\Jam\JamPresensi::create');

                                // simpan jam presensi
                                // URL : /admin/jam-presensi/store
                                $routes->post('store', 'Admin\Jam\JamPresensi::store');

                                // form edit jam presensi
                                // URL : /admin/jam-presensi/edit/{id}
                                $routes->get('edit/(:num)', 'Admin\Jam\JamPresensi::edit/$1');

                                // update jam presensi
                                // URL : /admin/jam-presensi/update/{id}
                                $routes->post('update/(:num)', 'Admin\Jam\JamPresensi::update/$1');

                                // aktif / nonaktif jam presensi
                                // URL : /admin/jam-presensi/toggle/{id}
                                $routes->get('toggle/(:num)', 'Admin\Jam\JamPresensi::toggle/$1');

                                // hapus jam presensi
                                // URL : /admin/jam-presensi/delete/{id}
                                $routes->get('delete/(:num)', 'Admin\Jam\JamPresensi::delete/$1');

                            });

                        });

                // ⚙️ Sub Menu 3
                    // 🗂️ 🔑 SETING EDIT DATA UNIK / UNIQUE CODE SISWA             // URL : http://localhost/qr-admin-2026/admin/siswa/kelas
                            // admin/siswa/kelas
                            $routes->group('admin/siswa', ['filter' => 'role'], function ($routes) {

                                // halaman utama data siswa
                                // URL : /admin/siswa
                                $routes->get('/', 'Admin\Siswa::index');

                                // pilih kelas
                                // URL : /admin/siswa/kelas
                                $routes->get('kelas', 'Admin\Siswa::pilihKelas');

                                // tampil siswa berdasarkan kelas
                                // URL : /admin/siswa/kelas/{id_kelas}
                                $routes->get('kelas/(:num)', 'Admin\Siswa::siswaByKelas/$1');

                                // form edit unique code siswa
                                // URL : /admin/siswa/edit-code/{id_siswa}
                                $routes->get('edit-code/(:num)', 'Admin\Siswa::editCode/$1');

                                // update unique code siswa
                                // URL : /admin/siswa/update-code/{id_siswa}
                                $routes->post('update-code/(:num)', 'Admin\Siswa::updateCode/$1');

                            });

                // ⚙️ Sub Menu 4
                    // 🗂️ 📅 HARI LIBUR         // URL : http://localhost/qr-admin-2026/admin/harilibur
                                    // admin/harilibur
                            $routes->group('admin/harilibur', ['filter' => 'role'], function ($routes) {

                                // halaman utama hari libur
                                // URL : /admin/harilibur
                                $routes->get('/', 'Admin\HariLibur\HariLiburController::index');

                                // ambil data hari libur (AJAX)
                                // URL : /admin/harilibur/list
                                $routes->get('list', 'Admin\HariLibur\HariLiburController::list');

                                // tambah data hari libur (AJAX)
                                // URL : /admin/harilibur/add
                                $routes->post('add', 'Admin\HariLibur\HariLiburController::add');

                                // update data hari libur (AJAX)
                                // URL : /admin/harilibur/update/{id}
                                $routes->post('update/(:num)', 'Admin\HariLibur\HariLiburController::update/$1');

                                // hapus data hari libur (AJAX)
                                // URL : /admin/harilibur/delete/{id}
                                $routes->get('delete/(:num)', 'Admin\HariLibur\HariLiburController::delete/$1');

                                // halaman view
                                // URL : /admin/harilibur/view
                                $routes->get('view', 'Admin\HariLibur\HariLiburController::view');

                            });

                // ⚙️ Sub Menu 5
                    // 🗂️ ⚙️ SETING PELANGGARAN SISWA | URL : http://localhost/qr-admin-2026/admin/pelanggaran/inputjenispelanggaran
                                // admin/pelanggaran/inputjenispelanggaran
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // halaman utama
                                $routes->get('pelanggaran/inputjenispelanggaran', 'Admin\Pelanggaran\InputJenisPelanggaran::index');

                                // simpan
                                $routes->post('pelanggaran/inputjenispelanggaran/simpan', 'Admin\Pelanggaran\InputJenisPelanggaran::simpan');

                                // edit
                                $routes->post('pelanggaran/inputjenispelanggaran/edit/(:num)', 'Admin\Pelanggaran\InputJenisPelanggaran::edit/$1');

                                // hapus
                                $routes->post('pelanggaran/inputjenispelanggaran/hapus/(:num)', 'Admin\Pelanggaran\InputJenisPelanggaran::hapus/$1');

                            });

                // ⚙️ Sub Menu 6
                    // 🗂️ 📛 CHANGE PASSWORD | URL : http://localhost/qr-admin-2026/admin/userloginaktif
                                // admin/userloginaktif
                                $routes->group('admin', ['filter' => 'login'], function ($routes) {

                                    $routes->get('userloginaktif', 'Admin\UserLoginAktif\UserLoginAktif::index');
                                    $routes->post('userloginaktif/update', 'Admin\UserLoginAktif\UserLoginAktif::updatePassword');

                                });
                // ⚙️ Sub Menu 6
                    // 🗂️📛 SETING SIDEBAR MENU      //http://localhost/qr-admin-2026/admin/menus
                            //admin/menus
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {            
                                $routes->get('menus', 'Admin\Menus\MenusControl::index');
                                $routes->post('menus/store', 'Admin\Menus\MenusControl::store');
                                $routes->post('menus/update/(:num)', 'Admin\Menus\MenusControl::update/$1');
                                $routes->get('menus/delete/(:num)', 'Admin\Menus\MenusControl::delete/$1');
                            });

                // ⚙️ Sub Menu 7
                    // ----------------------
                    // 🛡️ ROUTES ADMIN - ROLE ROUTE SETTING
                    // ----------------------
                            // ✅http://localhost/qr-admin-2026/admin/roolseting/role-route
                            // ----------------------
                            // 🔹 HALAMAN UTAMA         
                            // ----------------------
                                $routes->group('admin/roolseting', ['filter' => 'role'],function($routes){
                                    $routes->get('role-route', 'Admin\RoolSeting\RoleRouteController::index');
                            // ----------------------
                            // 🔹 TAMBAH DATA
                            // ----------------------                          
                                    $routes->get('role-route/create', 'Admin\RoolSeting\RoleRouteController::create');
                                    $routes->post('role-route/store', 'Admin\RoolSeting\RoleRouteController::store');
                            // ----------------------
                            // 🔹 EDIT DATA
                            // ---------------------- 
                                    $routes->get('role-route/edit/(:num)', 'Admin\RoolSeting\RoleRouteController::edit/$1');
                                    $routes->post('role-route/update/(:num)', 'Admin\RoolSeting\RoleRouteController::update/$1');
                            // ----------------------
                            // 🔹 HAPUS DATA
                            // ----------------------
                                    $routes->get('role-route/delete/(:num)', 'Admin\RoolSeting\RoleRouteController::delete/$1');
                                });                    
                                //     // Url  : admin/roolseting/role-route
                                //     // Url  : admin/roolseting/role-route/store
                                //     // Url  : admin/roolseting/store
                                //     // Url  : admin/roolseting/edit/{id}
                                //     // Url  : admin/roolseting/update/{id}
                                //     // Url  : admin/roolseting/delete/{id}
                    // ----------------------
                //----------------------------------------------


        // ----------------------
        // 🛑 MENU 8 LAIN - LAIN
        // ----------------------
                    // 🗂️ 🚫 ACCESS DENIED      // URL : http://localhost/qr-admin-2026/admin/access-denied
                            // admin/access-denied
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // halaman akses ditolak
                                $routes->get('access-denied', 'Admin\AccessDenied::index');

                            });

                    // 🗂️ ✅ DEVELOPER      // URL : http://localhost/qr-admin-2026/admin/developer
                            // admin/developer
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {

                                // halaman developer
                                $routes->get('developer', 'Admin\Developer::index');

                            });
                    // 🗂️ ✅ Backup      // URL : http://localhost/qr-admin-2026/admin/developer
                            // admin/developer
                            
                            // $routes->get('admin/backup', 'Admin\BackupController::index'); // Halaman tombol backup
                            // $routes->get('admin/backup/run', 'Admin\BackupController::run'); // Proses backup & download


                            // $routes->get('admin/restore', 'Admin\RestoreController::index');
                            // $routes->post('admin/restore/run', 'Admin\RestoreController::run');


                                    // ✅ http://localhost/qr-admin-2026/admin/backup
                            $routes->group('admin', ['filter' => 'role'], function ($routes) {                              
                                $routes->get('backup', 'Admin\BackupController::index'); // Halaman tombol backup
                                $routes->get('backup/run', 'Admin\BackupController::run'); // Proses backup & download


                                $routes->get('restore', 'Admin\RestoreController::index');
                                $routes->post('restore/run', 'Admin\RestoreController::run');
                             });

        // ----------------------
        // 🛑 MENU 3 - SYSTEM SUPERADMIN
        // ----------------------
                $routes->group('admin', ['filter' => 'role'], function($routes) {
                    $routes->get('menusuperadmin', 'Admin\MenuSuperAdmin::index'); 
                    // ✅ URL: http://localhost/qr-admin-2026/admin/menusuperadmin
                    // Url  : admin/menusuperadmin
                });                             

        //----------------------------------------------


// 📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛

//=================================================
//   PROJECT QRCODE SMAN 1 CIKATOMAS        //  ✅ Base URL: http://localhost/qr-admin-2026/
//=================================================  


        
        // 🗂️ UTAMA  

                // Admin
                $routes->group('admin', function (RouteCollection $routes) {           //http://localhost/qr-admin-2026/admin/dashboard
                    // Admin dashboard
                    $routes->get('/', 'Admin\Dashboard::index');
                    $routes->get('dashboard', 'Admin\Dashboard::index');

                    // Kelas
                    $routes->group('kelas', ['namespace' => 'App\Controllers\Admin'], function ($routes) {       //http://localhost/qr-admin-2026/admin/kelas
                        $routes->get('/', 'KelasController::index');
                        $routes->get('tambah', 'KelasController::tambahKelas');
                        $routes->post('tambahKelasPost', 'KelasController::tambahKelasPost');
                        $routes->get('edit/(:any)', 'KelasController::editKelas/$1');
                        $routes->post('editKelasPost', 'KelasController::editKelasPost');
                        $routes->post('deleteKelasPost', 'KelasController::deleteKelasPost');
                        $routes->post('list-data', 'KelasController::listData');
                    });

                    // Jurusan                                                                                   //http://localhost/qr-admin-2026/admin/jurusan
                    $routes->group('jurusan', ['namespace' => 'App\Controllers\Admin'], function ($routes) {     //
                        $routes->get('/', 'JurusanController::index');
                        $routes->get('tambah', 'JurusanController::tambahJurusan');
                        $routes->post('tambahJurusanPost', 'JurusanController::tambahJurusanPost');
                        $routes->get('edit/(:any)', 'JurusanController::editJurusan/$1');
                        $routes->post('editJurusanPost', 'JurusanController::editJurusanPost');
                        $routes->post('deleteJurusanPost', 'JurusanController::deleteJurusanPost');
                        $routes->post('list-data', 'JurusanController::listData');
                    });

                        // admin lihat data siswa                                                                      //http://localhost/qr-admin-2026/admin/siswa
                        // $routes->get('siswa', 'Admin\DataSiswa::index');
                        // $routes->post('siswa', 'Admin\DataSiswa::ambilDataSiswa');
                        // // admin tambah data siswa
                        // $routes->get('siswa/create', 'Admin\DataSiswa::formTambahSiswa');
                        // $routes->post('siswa/create', 'Admin\DataSiswa::saveSiswa');
                        // // admin edit data siswa
                        // $routes->get('siswa/edit/(:any)', 'Admin\DataSiswa::formEditSiswa/$1');
                        // $routes->post('siswa/edit', 'Admin\DataSiswa::updateSiswa');
                        // // admin hapus data siswa
                        // $routes->delete('siswa/delete/(:any)', 'Admin\DataSiswa::delete/$1');
                        // $routes->get('siswa/bulk', 'Admin\DataSiswa::bulkPostSiswa');

                    // POST Data Siswa

                    // $routes->group('siswa', ['namespace' => 'App\Controllers\Admin'], function ($routes) {       // //http://localhost/qr-admin-2026/admin/siswa
                    //     $routes->post('downloadCSVFilePost', 'DataSiswa::downloadCSVFilePost');
                    //     $routes->post('generateCSVObjectPost', 'DataSiswa::generateCSVObjectPost');
                    //     $routes->post('importCSVItemPost', 'DataSiswa::importCSVItemPost');
                    //     $routes->post('deleteSelectedSiswa', 'DataSiswa::deleteSelectedSiswa');
                    // });


                    // admin lihat data guru
                    $routes->get('guru', 'Admin\DataGuru::index');
                    $routes->post('guru', 'Admin\DataGuru::ambilDataGuru');
                    // admin tambah data guru
                    $routes->get('guru/create', 'Admin\DataGuru::formTambahGuru');
                    $routes->post('guru/create', 'Admin\DataGuru::saveGuru');
                    // admin edit data guru
                    $routes->get('guru/edit/(:any)', 'Admin\DataGuru::formEditGuru/$1');
                    $routes->post('guru/edit', 'Admin\DataGuru::updateGuru');
                    // admin hapus data guru
                    $routes->delete('guru/delete/(:any)', 'Admin\DataGuru::delete/$1');


                    // // admin lihat data absen siswa                                                                // http://localhost/qr-admin-2026/admin/absen-siswa
                    // $routes->get('absen-siswa', 'Admin\DataAbsenSiswa::index');
                    // $routes->post('absen-siswa', 'Admin\DataAbsenSiswa::ambilDataSiswa'); // ambil siswa berdasarkan kelas dan tanggal
                    // $routes->post('absen-siswa/kehadiran', 'Admin\DataAbsenSiswa::ambilKehadiran'); // ambil kehadiran siswa
                    // $routes->post('absen-siswa/edit', 'Admin\DataAbsenSiswa::ubahKehadiran'); // ubah kehadiran siswa

                    // // admin lihat data absen guru
                    // $routes->get('absen-guru', 'Admin\DataAbsenGuru::index');
                    // $routes->post('absen-guru', 'Admin\DataAbsenGuru::ambilDataGuru'); // ambil guru berdasarkan tanggal
                    // $routes->post('absen-guru/kehadiran', 'Admin\DataAbsenGuru::ambilKehadiran'); // ambil kehadiran guru
                    // $routes->post('absen-guru/edit', 'Admin\DataAbsenGuru::ubahKehadiran'); // ubah kehadiran guru

                    // // admin generate QR                                                                         //http://localhost/qr-admin-2026/admin/generate
                    // $routes->get('generate', 'Admin\GenerateQR::index');
                    // $routes->post('generate/siswa-by-kelas', 'Admin\GenerateQR::getSiswaByKelas'); // ambil siswa berdasarkan kelas

                    // // Generate QR
                    // $routes->post('generate/siswa', 'Admin\QRGenerator::generateQrSiswa');
                    // $routes->post('generate/guru', 'Admin\QRGenerator::generateQrGuru');

                    // // Download QR
                    // $routes->get('qr/siswa/download', 'Admin\QRGenerator::downloadAllQrSiswa');
                    // $routes->get('qr/siswa/(:any)/download', 'Admin\QRGenerator::downloadQrSiswa/$1');
                    // $routes->get('qr/guru/download', 'Admin\QRGenerator::downloadAllQrGuru');
                    // $routes->get('qr/guru/(:any)/download', 'Admin\QRGenerator::downloadQrGuru/$1');

                    // admin buat laporan                                                                  //http://localhost/qr-admin-2026/admin/laporan
                    $routes->get('laporan', 'Admin\GenerateLaporan::index'); 
                    $routes->post('laporan/siswa', 'Admin\GenerateLaporan::generateLaporanSiswa');
                    $routes->post('laporan/guru', 'Admin\GenerateLaporan::generateLaporanGuru');

                    // superadmin lihat data petugas                                                    //http://localhost/qr-admin-2026/admin/petugas
                    $routes->get('petugas', 'Admin\DataPetugas::index');
                    $routes->post('petugas', 'Admin\DataPetugas::ambilDataPetugas');
                    // superadmin tambah data petugas
                    $routes->get('petugas/register', 'Admin\DataPetugas::registerPetugas');
                    // superadmin edit data petugas
                    $routes->get('petugas/edit/(:any)', 'Admin\DataPetugas::formEditPetugas/$1');
                    $routes->post('petugas/edit', 'Admin\DataPetugas::updatePetugas');
                    // superadmin hapus data petugas
                    $routes->delete('petugas/delete/(:any)', 'Admin\DataPetugas::delete/$1');

                    // superadmin simpan data petugas baru
                    $routes->post('petugas/save', 'Admin\DataPetugas::savePetugas');


                    // Settings //http://localhost/qr-admin-2026/admin/general-settings
                    // $routes->group('general-settings', ['namespace' => 'App\Controllers\Admin'], function ($routes) {
                    //     $routes->get('/', 'GeneralSettings::index');
                    //     $routes->post('update', 'GeneralSettings::generalSettingsPost');
                    // });
                });
// 📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛📛


    // ===================================================
    // 🗂️ ROUTES ADMIN - REKAP KEHADIRAN HARIAN
    // Base URL: http://localhost/qr-admin-2026/admin/kehadiran
    // ===================================================
                                                        
                    $routes->group('admin', ['filter' => 'role'], function($routes) {
                        $routes->group('kehadiran', function($routes) {

                            // ----------------------
                            // 🔹 REKAP HARIAN
                            // ----------------------
                            $routes->get('rekapharian', 'Admin\Kehadiran\RekapHarian::index'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/kehadiran/rekapharian
                            // Halaman rekap kehadiran harian siswa

                            // ----------------------
                            // 🔹 EXPORT CSV
                            // ----------------------
                            $routes->get('exportCSV', 'Admin\Kehadiran\RekapHarian::exportCSV'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/kehadiran/exportCSV
                            // Export rekap kehadiran harian ke CSV
                        });
                    });




    // ===================================================
    // 🗂️ ROUTES ADMIN - LAPORAN KEHADIRAN SISWA (VERSI 2)
    // Base URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran
    // ===================================================

                    $routes->group('admin', ['filter' => 'role'], function($routes) {

                        // ----------------------
                        // 🔹 DATA SISWA
                        // ----------------------
                        $routes->get('laporan/kehadiran/jmlsiswa', 'Admin\laporan\kehadiran\ControllerHSIA::dassiswajml'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/jmlsiswa
                        // Jumlah siswa per kelas

                        $routes->get('laporan/kehadiran/siswahadir', 'Admin\laporan\kehadiran\ControllerHSIA::dassiswahadir'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswahadir
                        // Siswa hadir

                        $routes->get('laporan/kehadiran/siswasakit', 'Admin\laporan\kehadiran\ControllerHSIA::dassiswasakit'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswasakit
                        // Siswa sakit

                        $routes->get('laporan/kehadiran/siswaizin', 'Admin\laporan\kehadiran\ControllerHSIA::dassiswaizin'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswaizin
                        // Siswa izin

                        $routes->get('laporan/kehadiran/siswaalpa', 'Admin\laporan\kehadiran\ControllerHSIA::dassiswaalpa'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswaalpa
                        // Siswa alpa / tidak hadir tanpa keterangan

                        // ----------------------
                        // 🔹 REKAP KEHADIRAN
                        // ----------------------
                        $routes->get('laporan/kehadiran/rekharian', 'Admin\laporan\kehadiran\ControllerHSIA::dasharian'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekharian
                        // Rekap harian

                        $routes->get('laporan/kehadiran/rekmingguan', 'Admin\laporan\kehadiran\ControllerHSIA::dasmingguan'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekmingguan
                        // Rekap mingguan

                        $routes->get('laporan/kehadiran/rekbulanan', 'Admin\laporan\kehadiran\ControllerHSIA::dasbulanan'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekbulanan
                        // Rekap bulanan

                        $routes->get('laporan/kehadiran/rekpersiswa', 'Admin\laporan\kehadiran\ControllerHSIA::daspersiswa'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekpersiswa
                        // Rekap per siswa

                        $routes->get('laporan/kehadiran/rekbelumabsen', 'Admin\laporan\kehadiran\ControllerHSIA::belumabsen'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekbelumabsen
                        // Siswa yang belum absen

                        // ----------------------
                        // 🔹 SANKSI / SPESIAL
                        // ----------------------
                        $routes->get('laporan/kehadiran/siswaterlambat', 'Admin\laporan\kehadiran\ControllerHSIA::dasterlambat'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswaterlambat
                        // Siswa terlambat

                        $routes->get('laporan/kehadiran/siswatidaksholat', 'Admin\laporan\kehadiran\ControllerHSIA::dastidaksholat'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/siswatidaksholat
                        // Siswa tidak sholat

                        // ----------------------
                        // 🔹 LAPORAN BULANAN (ControllerLaporanBulanan)
                        // ----------------------
                        $routes->get('laporan/kehadiran/rekbulanan', 'Admin\laporan\kehadiran\ControllerLaporanBulanan::index'); 
                        // ✅ URL: http://localhost/qr-admin-2026/admin/laporan/kehadiran/rekbulanan
                        // Rekap bulanan versi ControllerLaporanBulanan (hati-hati, duplicate route jika sebelumnya sudah ada)
                    });                                                                         



    // ===================================================
    // 🗂️ ROUTES ADMIN - LAPORAN SOLAT DUHUR SISWA
    // Base URL: http://localhost/qr-admin-2026/admin/duhur
    // ===================================================

                    $routes->group('admin', ['filter' => 'role'], function($routes) {

                        // ----------------------
                        // 🔹 REKAP HARIAN
                        // ----------------------
                        $routes->group('duhur', function($routes){
                            $routes->get('sholatduhur', 'Admin\Duhur\HarianDuhur::index'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/sholatduhur
                            // Halaman utama rekap harian solat dhuhr

                            $routes->get('sholatduhur/exportCSV', 'Admin\Duhur\HarianDuhur::exportCSV'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/sholatduhur/exportCSV
                            // Export CSV rekap harian solat dhuhr
                        });

                        // ----------------------
                        // 🔹 REKAP BULANAN & DETAIL SISWA
                        // ----------------------
                        $routes->group('duhur', function($routes){
                            // Rekap bulanan per siswa
                            $routes->get('rekapdetail', 'Admin\Duhur\BulananDuhur::index'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/rekapdetail

                            // Detail harian per siswa
                            $routes->get('rekapdetail/detail/(:num)', 'Admin\Duhur\BulananDuhur::detail/$1'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/rekapdetail/detail/{id}

                            // Export CSV rekap bulanan
                            $routes->get('rekapdetail/exportCSV', 'Admin\Duhur\BulananDuhur::exportCSV'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/rekapdetail/exportCSV

                            // Export CSV detail harian per siswa
                            $routes->get('bulananDuhur/exportCSVDetail', 'Admin\Duhur\BulananDuhur::exportCSVDetail'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/bulananDuhur/exportCSVDetail
                        });

                        // ----------------------
                        // 🔹 DETAIL BULANAN PER SISWA (langsung group admin/duhur)
                        // ----------------------
                        $routes->group('duhur', function($routes){
                            $routes->get('bulananDuhur/detail/(:num)', 'Admin\Duhur\BulananDuhur::detail/$1'); 
                            // ✅ URL: http://localhost/qr-admin-2026/admin/duhur/bulananDuhur/detail/{id}
                        });

                    });

//🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️
                   


                    

                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    

























//🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️🗂️

/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {
   require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
