<?php

namespace App\Controllers\Admin\AbsenOtomatis;

use App\Controllers\BaseController;
use App\Models\SiswaModel;
use App\Models\KelasModel;
use App\Models\PresensiSiswaModel;
use CodeIgniter\I18n\Time;

class AbsenOtomatis extends BaseController
{
    protected $siswaModel;
    protected $kelasModel;
    protected $presensiModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->kelasModel = new KelasModel();
        $this->presensiModel = new PresensiSiswaModel();
    }

    public function index()
    {
        $data = [
            'kelas' => $this->kelasModel->getAllKelas(),
            'title' => 'Absensi Otomatis',
            'ctx' => 'absenotomatis',
        ];
        return view('admin/absenotomatis/absen_otomatis', $data);
    }

    public function simpan()
    {
        $post = $this->request->getPost();

        $idKelas = $post['id_kelas'] ?? 'all';
        $jenisAbsen = $post['jenis_absen']; // masuk, sholat, pulang
        $jam = $post['jam']; // format HH:MM
        $tanggal = $post['tanggal'] ?? date('Y-m-d'); // tanggal dari form, default hari ini

        // ambil siswa sesuai pilihan
        if ($idKelas === 'all') {
            $siswaList = $this->siswaModel->getAllSiswaWithKelas();
        } else {
            $siswaList = $this->siswaModel->getSiswaByKelas($idKelas);
        }

        foreach ($siswaList as $siswa) {
            $idSiswa = $siswa['id_siswa'];
            $idKelasSiswa = $siswa['id_kelas'];

            // ambil presensi tanggal tertentu
            $presensi = $this->presensiModel->getPresensiByIdSiswaTanggal($idSiswa, $tanggal);

            // skip siswa yang sakit atau izin
            if ($presensi && in_array($presensi['id_kehadiran'], [2, 3])) {
                continue;
            }

            switch ($jenisAbsen) {
                case 'masuk':
                    if (!$presensi) {
                        $this->presensiModel->absenMasuk($idSiswa, $tanggal, $jam, $idKelasSiswa);
                    }
                    break;

                case 'sholat':
                    if ($presensi && $presensi['id_kehadiran'] == 1) {
                        $this->presensiModel->absenSolat($idSiswa, $idKelasSiswa, $tanggal, $jam);
                    }
                    break;

                case 'pulang':
                    if ($presensi && $presensi['id_kehadiran'] == 1) {
                        $this->presensiModel->absenKeluar($presensi['id_presensi'], $jam);
                    }
                    break;
            }
        }

        return redirect()->back()->with('success', 'Absensi otomatis berhasil disimpan.');
    }
}
