<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController; // pastikan BaseController sudah memuat session/helper
use CodeIgniter\Files\File;

class BackupController extends BaseController
{
    protected $sidebarMenus = [
        ['ctx' => 'dashboard', 'label' => 'Dashboard', 'icon' => 'dashboard', 'url' => 'admin/dashboard', 'children' => []],
        ['ctx' => 'backup', 'label' => 'Backup Database', 'icon' => 'backup', 'url' => 'admin/backup', 'children' => []],
        ['ctx' => 'restore', 'label' => 'Restore Database', 'icon' => 'restore', 'url' => 'admin/restore', 'children' => []],
    ];

    public function index()
    {
        $data = [
            'title' => 'Backup Database',
            'ctx'   => 'backup',
            'sidebarMenus' => $this->sidebarMenus
        ];

        return view('admin/backup/backup', $data);
    }

    public function run()
    {
        helper('filesystem');

        $db = \Config\Database::connect();
        $filename = 'backup_db_' . date('Ymd_His') . '.sql';
        $tables = $db->listTables();
        $sql = '';

        foreach ($tables as $table) {
            $res = $db->query("SHOW CREATE TABLE `$table`")->getRowArray();
            $sql .= $res['Create Table'] . ";\n\n";

            $data = $db->table($table)->get()->getResultArray();
            foreach ($data as $row) {
                $columns = implode('`,`', array_keys($row));

                $valuesArray = [];
                foreach ($row as $val) {
                    if (is_null($val)) {
                        $valuesArray[] = "NULL";
                    } else {
                        // Gunakan escapeString dengan tipe string
                        $valuesArray[] = "'" . $db->escapeString((string)$val) . "'";
                    }
                }
                $values = implode(',', $valuesArray);

                $sql .= "INSERT INTO `$table` (`$columns`) VALUES ($values);\n";
            }
            $sql .= "\n\n";
        }

        $backupPath = WRITEPATH . 'backup/';
        if (!is_dir($backupPath)) mkdir($backupPath, 0755, true);

        write_file($backupPath . $filename, $sql);

        return $this->response->download($backupPath . $filename, null)->setFileName($filename);
    }
}
