<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\GuruModel;
use App\Models\SiswaModel;
use App\Models\KelasModel;
use App\Models\PetugasModel;
use App\Models\PresensiGuruModel;
use App\Models\PresensiSiswaModel;
use CodeIgniter\I18n\Time;

class Dashboard extends BaseController
{
    protected SiswaModel $siswaModel;
    protected GuruModel $guruModel;
    protected KelasModel $kelasModel;
    protected PresensiSiswaModel $presensiSiswaModel;
    protected PresensiGuruModel $presensiGuruModel;
    protected PetugasModel $petugasModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->guruModel = new GuruModel();
        $this->kelasModel = new KelasModel();
        $this->presensiSiswaModel = new PresensiSiswaModel();
        $this->presensiGuruModel = new PresensiGuruModel();
        $this->petugasModel = new PetugasModel();
    }

    public function index()
    {
        $now = Time::now();
        $dateRange = [];
        $siswaKehadiranArray = [];
        $guruKehadiranArray = [];

        for ($i = 6; $i >= 0; $i--) {
            $date = $now->subDays($i)->toDateString();
            $formattedDate = $i === 0 ? 'Hari ini' : $now->subDays($i)->toLocalizedString('d MMM');

            array_push($dateRange, $formattedDate);

            array_push(
                $siswaKehadiranArray,
                count($this->presensiSiswaModel
                    ->where(['tanggal' => $date, 'id_kehadiran' => '1'])
                    ->findAll())
            );

            array_push(
                $guruKehadiranArray,
                count($this->presensiGuruModel
                    ->where(['tanggal' => $date, 'id_kehadiran' => '1'])
                    ->findAll())
            );
        }

        $today = $now->toDateString();

        $data = [
            'title' => 'Dashboard',
            'ctx' => 'dashboard',
            'siswa' => $this->siswaModel->getAllSiswaWithKelas(),
            'guru' => $this->guruModel->getAllGuru(),
            'kelas' => $this->kelasModel->getDataKelas(),
            'dateRange' => $dateRange,
            'dateNow' => $now->toLocalizedString('d MMMM Y'),
            'grafikKehadiranSiswa' => $siswaKehadiranArray,
            'grafikKehadiranGuru' => $guruKehadiranArray,
            'jumlahKehadiranSiswa' => [
                'hadir' => count($this->presensiSiswaModel->getPresensiByKehadiran('1', $today)),
                'sakit' => count($this->presensiSiswaModel->getPresensiByKehadiran('2', $today)),
                'izin' => count($this->presensiSiswaModel->getPresensiByKehadiran('3', $today)),
                'alfa' => count($this->presensiSiswaModel->getPresensiByKehadiran('4', $today)),
            ],
            'jumlahKehadiranGuru' => [
                'hadir' => count($this->presensiGuruModel->getPresensiByKehadiran('1', $today)),
                'sakit' => count($this->presensiGuruModel->getPresensiByKehadiran('2', $today)),
                'izin' => count($this->presensiGuruModel->getPresensiByKehadiran('3', $today)),
                'alfa' => count($this->presensiGuruModel->getPresensiByKehadiran('4', $today)),
            ],
            'petugas' => $this->petugasModel->getAllPetugas(),
        ];

        return view('admin/dashboard', $data);
    }
}
