<?php

namespace App\Controllers\Admin\Duhur;

use App\Controllers\BaseController;
use App\Models\Duhur\RekapDetailDuhurMod;
use App\Models\Duhur\KelasModel;

class BulananDuhur extends BaseController
{
    protected $model;
    protected $kelasModel;

    public function __construct()
    {
        $this->model = new RekapDetailDuhurMod();
        $this->kelasModel = new KelasModel();
    }

    // REKAP BULANAN PER SISWA
    public function index()
    {
        $bulan = $this->request->getVar('bulan') ?? date('Y-m');
        $idKelas = $this->request->getVar('kelas') ?? '';

        $kelasList = $this->kelasModel->getKelas();
        $rekap = [];

        if (!empty($idKelas)) {
            $rekap = $this->model->getRekap($idKelas, $bulan);
        }

        return view('admin/duhur/bulananduhur', [
            'title' => 'REKAP BULANAN SOLAT DUHUR',
            'ctx' => 'bulananduhur',
            'rekap' => $rekap,
            'kelasList' => $kelasList,
            'selectedKelas' => $idKelas,
            'bulan' => $bulan
        ]);
    }

    // DETAIL HARIAN PER SISWA

// -------------------------------------------------------------------

public function detail($idSiswa)
{
    $bulan = $this->request->getVar('bulan') ?? date('Y-m');
    $selectedKelas = $this->request->getVar('kelas') ?? '';

    // Ambil detail harian siswa
    $detail = $this->model->getDetailHarian($idSiswa, $bulan);

    // Ambil nama siswa
    $namaSiswa = $this->model->getNamaSiswa($idSiswa); // <-- pastikan ini ada

    return view('admin/duhur/detailpersiswa', [
        'title' => 'REKAP SOLAT DUHUR PERSISWA',
        'ctx' => 'bulananduhur',
        'detail' => $detail,
        'bulan' => $bulan,
        'selectedKelas' => $selectedKelas,
        'namaSiswa' => $namaSiswa, // <-- kirim ke view
    ]);
}



// -------------------------------------------------------------------
    // EXPORT CSV REKAP
    public function exportCSV()
    {
        $bulan = $this->request->getVar('bulan') ?? date('Y-m');
        $idKelas = $this->request->getVar('kelas') ?? '';

        if (empty($idKelas)) {
            return redirect()->back()->with('error', 'Pilih kelas terlebih dahulu.');
        }

        $rekap = $this->model->getRekap($idKelas, $bulan);

        $filename = "REKAP_BULANAN_SHOLAT_DUHUR_{$bulan}.csv";

        header('Content-Type: text/csv; charset=UTF-8');
        header('Content-Disposition: attachment; filename="' . $filename . '"');
        echo "\xEF\xBB\xBF";

        $output = fopen('php://output', 'w');
        fputcsv($output, ['No','Nama Siswa','Kelas','Jumlah Hadir','Total Hari','Persentase (%)'], ';');

        $no = 1;
        foreach ($rekap as $row) {
            $persen = $row['total_hari'] > 0 ? round(($row['hadir']/$row['total_hari'])*100,2) : 0;
            fputcsv($output, [
                $no++,
                $row['nama_siswa'],
                $row['nama_kelas'],
                $row['hadir'],
                $row['total_hari'],
                $persen
            ], ';');
        }

        fclose($output);
        exit;
    }

// ---------------------------------------------------------

// -------------------------------------------------------------------
    // EXPORT CSV REKAP

    public function exportCSVDetail()
{
    $idSiswa = $this->request->getVar('idSiswa');
    $bulan = $this->request->getVar('bulan') ?? date('Y-m');

    if (empty($idSiswa)) {
        return redirect()->back()->with('error', 'ID siswa tidak ditemukan.');
    }

    // Ambil detail harian siswa
    $detail = $this->model->getDetailHarian($idSiswa, $bulan);

    // Nama siswa
    $namaSiswa = $this->model->getNamaSiswa($idSiswa);

    // Nama file CSV
    $filename = "Detail_Harian_{$namaSiswa}_{$bulan}.csv";

    // Header CSV
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    echo "\xEF\xBB\xBF"; // BOM UTF-8

    $output = fopen('php://output', 'w');

    // Header kolom
    fputcsv($output, ['No', 'Tanggal', 'Jam Sholat', 'Status'], ';');

    // Tulis data
    $no = 1;
    foreach ($detail as $row) {
        $status = !empty($row['jam_sholat']) ? 'Hadir' : 'Alpa';
        fputcsv($output, [
            $no++,
            $row['tanggal'],
            $row['jam_sholat'] ?? '-',
            $status
        ], ';');
    }

    fclose($output);
    exit;
}




}
