<?php
namespace App\Controllers\Admin\Duhur;

use App\Controllers\BaseController;
use App\Models\Duhur\PresensiSiswaModel;
use App\Models\Duhur\KelasModel;
use App\Models\Duhur\SiswaModel; // tambahkan

class HarianDuhur extends BaseController
{
    protected $presensiModel;
    protected $kelasModel;
    protected $siswaModel;

    public function __construct()
    {
        $this->presensiModel = new PresensiSiswaModel();
        $this->kelasModel = new KelasModel();
        $this->siswaModel = new SiswaModel(); // inisialisasi
    }

    public function index()
    {
        $tanggal = $this->request->getVar('tanggal') ?? date('Y-m-d');
        $idKelas = $this->request->getVar('kelas') ?? '';

        $kelasList = $this->kelasModel->getKelas();
        $laporan = [];

        if (!empty($idKelas)) {
            // Ambil data presensi
            $presensi = $this->presensiModel->getPresensiByKelasTanggal($idKelas, $tanggal);
            // Ambil data siswa
            $siswa = $this->siswaModel->getSiswaByKelas($idKelas);

            // Gabungkan data presensi dengan jenis_kelamin siswa
            $laporan = array_map(function($p) use ($siswa) {
                $found = array_filter($siswa, fn($s) => $s['nama_siswa'] === $p['nama_siswa']);
                $p['jk'] = $found ? array_values($found)[0]['jenis_kelamin'] : '-';
                return $p;
            }, $presensi);
        }

        return view('admin/duhur/harianduhur', [
            'title' => 'REKAP HARIAN SOLAT DUHUR',
            'ctx' => 'harianduhur',
            'laporan' => $laporan,
            'kelasList' => $kelasList,
            'selectedKelas' => $idKelas,
            'tanggal' => $tanggal
        ]);
    }

                    public function exportCSV()
                {
                    $tanggal = $this->request->getVar('tanggal') ?? date('Y-m-d');
                    $idKelas = $this->request->getVar('kelas') ?? '';

                    if (empty($idKelas)) {
                        return redirect()->back()->with('error', 'Pilih kelas terlebih dahulu.');
                    }

                    $presensi = $this->presensiModel->getPresensiByKelasTanggal($idKelas, $tanggal);
                    $siswa = $this->siswaModel->getSiswaByKelas($idKelas);

                    // Gabungkan data presensi dengan jenis_kelamin siswa
                    $laporan = array_map(function($p) use ($siswa) {
                        $found = array_filter($siswa, fn($s) => $s['nama_siswa'] === $p['nama_siswa']);
                        $p['jk'] = $found ? array_values($found)[0]['jenis_kelamin'] : '-';
                        return $p;
                    }, $presensi);

                    $filename = "Laporan_Sholat_Duhur_{$tanggal}.csv";

                    header('Content-Type: text/csv; charset=UTF-8');
                    header('Content-Disposition: attachment; filename="' . $filename . '"');
                    echo "\xEF\xBB\xBF"; // BOM UTF-8

                    $output = fopen('php://output', 'w');

                    fputcsv($output, ['No','Nama Siswa','JK','Kelas','Tanggal','Jam Masuk','Jam Sholat','Jam Keluar','Status'], ';');

                    $no = 1;
                    foreach ($laporan as $row) {
                        // Status
                        $statusText = match($row['id_kehadiran'] ?? '') {
                            '1' => 'Hadir',
                            '2' => 'Sakit',
                            '3' => 'Izin',
                            default => 'Alpa',
                        };

                        // Jam Masuk
                        if(!empty($row['jam_masuk'])) {
                            $jamMasuk = $row['jam_masuk'];
                            if($row['jam_masuk'] > '07:00:00' && $row['id_kehadiran']=='1') {
                                $jamMasuk .= ' - Terlambat';
                            }
                        } else {
                            $jamMasuk = ''; //pakai strip
                        }

                        // Jam Sholat
                        if(!empty($row['jam_sholat'])) {
                            $jamSholat = $row['jam_sholat'];
                        } else {
                            $jamSholat = ($row['id_kehadiran']=='1') ? 'Tidak Solat' : ''; //pakai strip
                        }

                        // Jam Keluar
                        if(!empty($row['jam_keluar'])) {
                            $jamKeluar = $row['jam_keluar'];
                        } else {
                            $jamKeluar = ($row['id_kehadiran']=='1') ? 'TAP' : '';     //pakai strip
                        }

                        fputcsv($output, [
                            $no++,
                            $row['nama_siswa'] ?? '-',
                            $row['jk'] ?? '-',
                            $row['nama_kelas'] ?? '-',
                            $row['tanggal'] ?? $tanggal,
                            $jamMasuk,
                            $jamSholat,
                            $jamKeluar,
                            $statusText
                        ], ';');
                    }

                    fclose($output);
                    exit;
                }

}
