<?php

namespace App\Controllers\Admin\HariLibur;

use App\Controllers\BaseController;
use App\Models\HariLiburModel;

class HariLiburController extends BaseController
{
    protected $hariLiburModel;

    public function __construct()
    {
        $this->hariLiburModel = new HariLiburModel();
    }

    // Halaman utama
    public function index()
    {
        return view('admin/harilibur/harilibur', [
            'title' => 'Hari Libur'
        ]);
    }

    // Ambil data hari libur (AJAX)
    public function list()
    {
        $data = $this->hariLiburModel->orderBy('tanggal','ASC')->findAll();
        return $this->response->setJSON($data);
    }

    // Tambah data
    public function add()
    {
        $tanggal = $this->request->getPost('tanggal');
        $keterangan = $this->request->getPost('keterangan');

        if(!$tanggal || !$keterangan){
            return $this->response->setJSON(['status'=>false,'msg'=>'Tanggal dan keterangan wajib diisi']);
        }

        $this->hariLiburModel->insert([
            'tanggal' => $tanggal,
            'keterangan' => $keterangan
        ]);

        return $this->response->setJSON(['status'=>true,'msg'=>'Hari libur berhasil ditambahkan']);
    }

    // Update data (inline)
    public function update($id)
    {
        $data = [];
        if($this->request->getPost('tanggal')) $data['tanggal'] = $this->request->getPost('tanggal');
        if($this->request->getPost('keterangan')) $data['keterangan'] = $this->request->getPost('keterangan');

        $this->hariLiburModel->update($id,$data);
        return $this->response->setJSON(['status'=>true,'msg'=>'Hari libur berhasil diupdate']);
    }

    // Hapus data
    public function delete($id)
    {
        $this->hariLiburModel->delete($id);
        return $this->response->setJSON(['status'=>true,'msg'=>'Hari libur berhasil dihapus']);
    }



    // Halaman menampilkan hari libur saja
public function view()
{
    $harilibur = $this->hariLiburModel->orderBy('tanggal','ASC')->findAll();

    return view('admin/harilibur/view_harilibur', [
        'title' => 'Daftar Hari Libur',
        'harilibur' => $harilibur
    ]);
}






}
