<?php

//namespace App\Controllers\Admin;
namespace App\Controllers\Admin\Jam;

use App\Controllers\BaseController;
use App\Models\Jam\JamPresensiModel;

class JamPresensi extends BaseController
{
    protected JamPresensiModel $jamModel;

    public function __construct()
    {
        $this->jamModel = new JamPresensiModel();
    }

    // ================================
    // LIST JAM
    // ================================
    public function index()
    {
        return view('admin/jam_presensi/index', [
            'title' => 'Jam Presensi',
            'ctx' => 'jam-presensi',
            'jam'   => $this->jamModel->getAll()
        ]);
    }

    // ================================
    // TAMBAH
    // ================================
    public function create()
    {
        return view('admin/jam_presensi/create', [
            'title' => 'Tambah Jam Presensi'
        ]);
    }

    public function store()
    {
        $this->jamModel->insert([
            'jenis'       => $this->request->getPost('jenis'),
            'jam_mulai'   => $this->request->getPost('jam_mulai'),
            'jam_selesai' => $this->request->getPost('jam_selesai'),
            'aktif'       => 1
        ]);

        return redirect()->to('/admin/jam-presensi')
            ->with('success', 'Jam presensi berhasil ditambahkan');
    }

    // ================================
    // EDIT
    // ================================
    public function edit($id)
    {
        return view('admin/jam_presensi/edit', [
            'title' => 'Edit Jam Presensi',
            'row'   => $this->jamModel->find($id)
        ]);
    }

    public function update($id)
    {
        $this->jamModel->update($id, [
            'jenis'       => $this->request->getPost('jenis'),
            'jam_mulai'   => $this->request->getPost('jam_mulai'),
            'jam_selesai' => $this->request->getPost('jam_selesai'),
            'aktif'       => $this->request->getPost('aktif')
        ]);

        return redirect()->to('/admin/jam-presensi')
            ->with('success', 'Jam presensi berhasil diupdate');
    }

    // ================================
    // AKTIF / NONAKTIF
    // ================================
    public function toggle($id)
    {
        $row = $this->jamModel->find($id);
        $this->jamModel->update($id, [
            'aktif' => $row['aktif'] ? 0 : 1
        ]);

        return redirect()->back();
    }

    // ================================
    // DELETE (OPTIONAL)
    // ================================
    public function delete($id)
    {
        $this->jamModel->delete($id);
        return redirect()->back();
    }
}
