<?php

namespace App\Controllers\Admin\Kehadiran;

use App\Controllers\BaseController;
use App\Models\Kehadiran\PresensiModel;
use App\Models\Kehadiran\KelasModel;

class RekapBulanan extends BaseController
{
    protected $laporanModel;
    protected $kelasModel;

    public function __construct()
    {
        $this->laporanModel = new PresensiModel();
        $this->kelasModel = new KelasModel();
    }

//✅✅ Halaman Rekap Bulanan                //  function rekapBulanan()
            public function rekapBulanan()
            {
                $selectedKelas = $this->request->getGet('kelas') ?? '';
                $bulan = $this->request->getGet('bulan') ?? date('Y-m'); // default bulan sekarang

                $kelasList = $this->kelasModel->findAll();

                $laporan = [];
                if ($selectedKelas) {
                    // Ambil rekap bulanan
                    $laporan = $this->laporanModel->getPresensiBulanan($bulan, $selectedKelas);

                    // Tambahkan kolom TidakSholat untuk tiap siswa
                    foreach ($laporan as &$row) {
                        // Hitung total siswa yang tidak sholat
                        $jamSholat = $this->laporanModel->db->table('tb_presensi_siswa')
                            ->select('jam_sholat')
                            ->where('id_siswa', $row['id_siswa'])
                            ->where('DATE_FORMAT(tanggal,"%Y-%m")', $bulan)
                            ->get()
                            ->getResultArray();

                        $tidakSholat = 0;
                        foreach ($jamSholat as $j) {
                            if (empty($j['jam_sholat'])) $tidakSholat++;
                        }

                        $row['TidakSholat'] = $tidakSholat;
                    }
                }

                $data = [
                    'title' => 'Laporan Bulanan',
                    'kelasList' => $kelasList,
                    'laporan' => $laporan,
                    'selectedKelas' => $selectedKelas,
                    'bulan' => $bulan
                ];

                return view('admin/kehadiran/rekapbulanan', $data);
            }
// -----------------------------------------------------------------------
//✅✅ Exsport CSV Halaman Bulanan          //  function exportCSV
        // public function exportCSV()
        // {
        //     $kelas = $this->request->getGet('kelas');
        //     $bulan = $this->request->getGet('bulan');

        //     if (!$kelas || !$bulan) {
        //         return redirect()->back()->with('error', 'Kelas dan bulan harus dipilih.');
        //     }

        //     // Ambil data rekap bulanan
        //     $laporan = $this->laporanModel->getPresensiBulanan($bulan, $kelas);

        //     // Tambahkan kolom TidakSholat untuk tiap siswa
        //     foreach ($laporan as &$row) {
        //         $row['TidakSholat'] = $this->laporanModel->db->table('tb_presensi_siswa')
        //             ->select('COUNT(*) AS total')
        //             ->where('id_siswa', $row['id_siswa'])
        //             ->where('DATE_FORMAT(tanggal,"%Y-%m")', $bulan)
        //             ->where('jam_sholat IS NULL')
        //             ->get()
        //             ->getRowArray()['total'] ?? 0;
        //     }

        //     // Nama file CSV
        //     $filename = "laporan_kehadiran_" . date('Ymd_His') . ".csv";

        //     // Header CSV
        //     header('Content-Type: text/csv; charset=utf-8');
        //     header('Content-Disposition: attachment; filename="' . $filename . '"');
        //     header('Cache-Control: max-age=0');

        //     $output = fopen('php://output', 'w');

        //     // Header kolom
        //     fputcsv($output, ['No', 'Nama Siswa', 'Hadir', 'Sakit', 'Izin', 'Alpa', 'Tidak Sholat Duhur'], ';');

        //     // Tulis data per baris
        //     $no = 1;
        //     foreach ($laporan as $row) {
        //         // Gunakan nilai alpha dari model
        //         fputcsv($output, [
        //             $no++,
        //             $row['nama_siswa'],
        //             $row['hadir'] ?? 0,
        //             $row['sakit'] ?? 0,
        //             $row['izin'] ?? 0,
        //             $row['alpha'] ?? 0,
        //             $row['TidakSholat'] ?? 0,
        //         ], ';');  // delimiter ; supaya Excel membaca tiap kolom
        //     }

        //     fclose($output);
        //     exit;
        // }


                public function exportCSV()
        {
            $kelas = $this->request->getGet('kelas');
            $bulan = $this->request->getGet('bulan');

            if (!$kelas || !$bulan) {
                return redirect()->back()->with('error', 'Kelas dan bulan harus dipilih.');
            }

            // Ambil nama kelas
            $kelasData = $this->kelasModel->find($kelas);
            $namaKelas = $kelasData['kelas'] ?? '-';

            // Ambil data rekap bulanan
            $laporan = $this->laporanModel->getPresensiBulanan($bulan, $kelas);

            // Tambahkan kolom TidakSholat untuk tiap siswa
            foreach ($laporan as &$row) {
                $row['TidakSholat'] = $this->laporanModel->db->table('tb_presensi_siswa')
                    ->select('COUNT(*) AS total')
                    ->where('id_siswa', $row['id_siswa'])
                    ->where('DATE_FORMAT(tanggal,"%Y-%m")', $bulan)
                    ->where('jam_sholat IS NULL')
                    ->get()
                    ->getRowArray()['total'] ?? 0;
            }

            // Nama file CSV
            $filename = "laporan_kehadiran_{$namaKelas}_{$bulan}_" . date('Ymd_His') . ".csv";

            // Header CSV
            header('Content-Type: text/csv; charset=utf-8');
            header('Content-Disposition: attachment; filename="' . $filename . '"');
            header('Cache-Control: max-age=0');

            $output = fopen('php://output', 'w');

            // ==== Judul Tabel di atas header ====
            fputcsv($output, ["Laporan Kehadiran Siswa"], ';');
            fputcsv($output, ["Kelas:", $namaKelas], ';');
            fputcsv($output, ["Bulan:", date('F Y', strtotime($bulan.'-01'))], ';');
            fputcsv($output, []); // baris kosong sebelum header

            // Header kolom
            fputcsv($output, ['No', 'Nama Siswa', 'Hadir', 'Sakit', 'Izin', 'Alpa', 'Tidak Sholat Duhur'], ';');

            // Tulis data per baris
            $no = 1;
            foreach ($laporan as $row) {
                fputcsv($output, [
                    $no++,
                    $row['nama_siswa'],
                    $row['hadir'] ?? 0,
                    $row['sakit'] ?? 0,
                    $row['izin'] ?? 0,
                    $row['alpha'] ?? 0,
                    $row['TidakSholat'] ?? 0,
                ], ';');  // delimiter ; supaya Excel membaca tiap kolom
            }

            fclose($output);
            exit;
        }








// -----------------------------------------------------------------------
//✅✅ Halaman Detail Persiswa              //  detailpersiswa
// -----------------------------------------------------------------------
    //✅✅ detail Versi 1                   //  detailpersiswa
        public function detail($idSiswa)
        {
            $bulan = $this->request->getVar('bulan') ?? date('Y-m');
            $selectedKelas = $this->request->getVar('kelas') ?? '';

            // Ambil data detail harian langsung dari database
            $detail = $this->laporanModel->getDetailHarian($idSiswa, $bulan);

            // Ambil nama siswa
            $namaSiswa = $this->laporanModel->getNamaSiswa($idSiswa);

            return view('admin/kehadiran/detailpersiswa', [
                'title' => 'Detail Kehadiran ' . $namaSiswa,
                'namaSiswa' => $namaSiswa,
                'idSiswa' => $idSiswa,
                'detail' => $detail,
                'bulan' => $bulan,
                'selectedKelas' => $selectedKelas
            ]);
        }

    // -----------------------------------------------------------------------
    //✅✅ detail Versi 2                   //  detailpersiswa
        // -----------------------------------
        // public function detail($idSiswa)
        // {
        //     $bulan = $this->request->getGet('bulan') ?? date('Y-m');
        //     $selectedKelas = $this->request->getGet('kelas') ?? '';

        //     // Ambil data siswa
        //     $siswa = $this->laporanModel->db->table('tb_siswa')
        //         ->select('id_siswa, nama_siswa')
        //         ->where('id_siswa', $idSiswa)
        //         ->get()
        //         ->getRowArray();

        //     $namaSiswa = $siswa['nama_siswa'] ?? 'Tidak Diketahui';

        //     // Ambil data presensi harian siswa
        //     $detail = $this->laporanModel->db->table('tb_presensi_siswa p')
        //         ->select('p.tanggal, p.jam_sholat')
        //         ->where('p.id_siswa', $idSiswa)
        //         ->where('DATE_FORMAT(p.tanggal,"%Y-%m")', $bulan)
        //         ->orderBy('p.tanggal', 'ASC')
        //         ->get()
        //         ->getResultArray();

        //     return view('admin/kehadiran/detailpersiswa', [
        //         'title' => 'Detail Kehadiran ' . $namaSiswa,
        //         'namaSiswa' => $namaSiswa,
        //         'detail' => $detail,
        //         'bulan' => $bulan,
        //         'selectedKelas' => $selectedKelas,
        //         'idSiswa' => $idSiswa   // <-- ini yang kurang
        //     ]);
        // }


// ---------------------------------- Halaman Pembatas
//✅✅ Exsport CSV Halaman Persiswa         // exportCSVDetail
        
            public function exportCSVDetail()
            {
                $idSiswa = $this->request->getGet('idSiswa');
                $bulan   = $this->request->getGet('bulan') ?? date('Y-m');

                if (!$idSiswa) {
                    return redirect()->back()->with('error', 'Siswa tidak dipilih.');
                }

                // Helper untuk format tanggal + hari
                function formatTanggalHari($tanggal)
                {
                    if (!$tanggal) return '-';
                    $hari = [
                        'Sunday'=>'Minggu','Monday'=>'Senin','Tuesday'=>'Selasa',
                        'Wednesday'=>'Rabu','Thursday'=>'Kamis','Friday'=>'Jumat','Saturday'=>'Sabtu'
                    ];
                    return $hari[date('l', strtotime($tanggal))] . ', ' . date('d-m-Y', strtotime($tanggal));
                }

                // Ambil data siswa dan kelas
                $siswa = $this->laporanModel->db->table('tb_siswa s')
                    ->select('s.nama_siswa, s.id_kelas, k.kelas AS nama_kelas')
                    ->join('tb_kelas k', 'k.id_kelas = s.id_kelas', 'left')
                    ->where('s.id_siswa', $idSiswa)
                    ->get()
                    ->getRowArray();

                $namaSiswa  = $siswa['nama_siswa'] ?? 'Tidak Diketahui';
                $namaKelas  = $siswa['nama_kelas'] ?? '-';

                // Ambil detail presensi + join ke tb_kehadiran untuk status
                $detail = $this->laporanModel->db->table('tb_presensi_siswa p')
                    ->select('p.tanggal, p.jam_masuk, p.jam_keluar, p.jam_sholat, kh.kehadiran AS status')
                    ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left')
                    ->where('p.id_siswa', $idSiswa)
                    ->where('DATE_FORMAT(p.tanggal,"%Y-%m")', $bulan)
                    ->orderBy('p.tanggal', 'ASC')
                    ->get()
                    ->getResultArray();

                $filename = "Detail_Kehadiran_{$namaSiswa}_{$bulan}.csv";

                header('Content-Type: text/csv; charset=utf-8');
                header('Content-Disposition: attachment; filename="' . $filename . '"');
                echo "\xEF\xBB\xBF"; // UTF-8 BOM

                $out = fopen('php://output', 'w');

                // ==== Judul Tabel di atas header ====
                fputcsv($out, ["Detail Kehadiran Siswa"], ';');
                fputcsv($out, ["Nama Siswa:", $namaSiswa], ';');
                fputcsv($out, ["Kelas:", $namaKelas], ';');
                fputcsv($out, ["Bulan:", date('F Y', strtotime($bulan.'-01'))], ';');
                fputcsv($out, []); // baris kosong sebelum header

                // Header CSV
                fputcsv($out, [
                    'No','Tanggal','Status',
                    'Jam Masuk','Keterangan Masuk',
                    'Jam Sholat','Keterangan Sholat',
                    'Jam Keluar','Keterangan Keluar'
                ], ';');

                $no = 1;
                foreach ($detail as $row) {
                    // Status: jika null berarti Alpa
                    $status = $row['status'] ?? 'Alpa';

                    // Jam Masuk + Keterangan
                    $jamMasuk = $row['jam_masuk'] ?? '-';
                    $ketMasuk = '-';
                    if ($status === 'Hadir' && $jamMasuk !== '-' && $jamMasuk > '07:00') {
                        $ketMasuk = 'Telat';
                    }

                    // Jam Sholat + Keterangan
                    $jamSholat = $row['jam_sholat'] ?? '-';
                    $ketSholat = '-';
                    if (!in_array($status, ['Hadir'])) { // Sakit/Izin/Alpa
                        $ketSholat = '';
                        $jamSholat = '-';
                    } elseif (empty($row['jam_sholat'])) {
                        $ketSholat = 'Tidak Solat';
                    }

                    // Jam Keluar + Keterangan
                    if (!in_array($status, ['Hadir'])) { // Sakit/Izin/Alpa
                        $jamKeluar = '-';
                        $ketKeluar = '';
                    } else {
                        $jamKeluar = $row['jam_keluar'] ?? 'TAP';
                        $ketKeluar = ($jamKeluar === 'TAP') ? 'TAP' : '-';
                    }

                    fputcsv($out, [
                        $no++,
                        formatTanggalHari($row['tanggal']), // <-- format hari + tanggal
                        $status,
                        $jamMasuk,
                        $ketMasuk,
                        $jamSholat,
                        $ketSholat,
                        $jamKeluar,
                        $ketKeluar
                    ], ';');
                }

                fclose($out);
                exit;
            }







// -----------------------------------------------------------------------
}
