<?php

namespace App\Controllers\Admin\Kehadiran;

use App\Controllers\BaseController;
use App\Models\PresensiModel;
use App\Models\Kehadiran\KelasModel;

class RekapHarian extends BaseController
{
    protected $presensiModel;
    protected $kelasModel;

    public function __construct()
    {
        $this->presensiModel = new PresensiModel();
        $this->kelasModel    = new KelasModel();
    }


//1️⃣✅ HALAMAN REKAP HARIAN / rekapharian
    //✅✅ INDEX //  
        public function index()
        {
            $tanggal = $this->request->getGet('tanggal') ?? date('Y-m-d');
            $idKelas = $this->request->getGet('kelas');

            $laporan   = $this->presensiModel->getPresensiHarian($tanggal, $idKelas);
            $kelasList = $this->kelasModel->getKelas();

            return view('admin/kehadiran/rekapharian', [
                'title'         => 'Laporan Harian',
                'ctx'           => 'hadirharian',
                'laporan'       => $laporan,
                'kelasList'     => $kelasList,
                'selectedKelas' => $idKelas,
                'tanggal'       => $tanggal
            ]);
        }
    //-------------------------------------------------------------
// -----------------------------------------------------------------------
//2️⃣✅ EXSPORT CSV HARIAN   /   exportCSV     //  
    //🔥🔥 exportCSV //      
           public function exportCSV()
            {
                $tanggal = $this->request->getGet('tanggal') ?? date('Y-m-d');
                $idKelas = $this->request->getGet('kelas');

                if (empty($idKelas)) {
                    return redirect()->back()->with('error', 'Pilih kelas terlebih dahulu');
                }

                $data = $this->presensiModel->getPresensiHarian($tanggal, $idKelas);
                $filename = "Presensi_{$tanggal}.csv";

                header('Content-Type: text/csv; charset=UTF-8');
                header('Content-Disposition: attachment; filename="'.$filename.'"');
                echo "\xEF\xBB\xBF"; // BOM Excel untuk UTF-8

                $out = fopen('php://output', 'w');

                // Header CSV
                fputcsv($out, [
                    'No','Nama','JK','Kelas',
                    'Masuk','Keterangan Masuk',
                    'Duhur','Keterangan Duhur',
                    'Keluar',
                    'Status'
                ], ';');

                $no = 1;
                foreach ($data as $row) {
                    $status = $row['kehadiran'] ?? 'Alpa';

                    // ===== MASUK =====
                    $jamMasuk = $row['jam_masuk'] ?? '-';
                    $keteranganMasuk = '-';
                    if (!empty($row['jam_masuk'])) {
                        $telat = ($status === 'Hadir' && $row['jam_masuk'] > '07:00') ? 'Telat' : '';
                        $keteranganDb = $row['keterangan'] ?? '';
                        $keteranganMasuk = trim(($telat ? $telat : '') . ($keteranganDb ? ' • ' . $keteranganDb : ''));
                        if (empty($keteranganMasuk)) $keteranganMasuk = '-';
                    }

                    // ===== DUHUR =====
                    $jamDuhur = $row['jam_sholat'] ?? '-';
                    $keteranganDuhur = '-';
                    if ($status === 'Hadir') {
                        $keteranganDuhur = empty($row['jam_sholat']) ? 'Tidak Solat' : ($row['keterangan'] ?? '-');
                    }

                    // ===== KELUAR =====
                    if (in_array($status, ['Sakit','Izin','Alpa'])) {
                        $jamKeluar = '-';
                    } else {
                        $jamKeluar = $row['jam_keluar'] ?? 'TAP';
                    }
                    $keteranganKeluar = (!empty($row['jam_keluar']) || $jamKeluar === 'TAP') ? ($row['keterangan'] ?? '-') : '-';

                    fputcsv($out, [
                        $no++,
                        $row['nama_siswa'],
                        $row['jenis_kelamin'] ?? '-',
                        $row['kelas'] ?? '-',
                        $jamMasuk,
                        $keteranganMasuk,
                        $jamDuhur,
                        $keteranganDuhur,
                        $jamKeluar,
                        // $keteranganKeluar,
                        $status
                    ], ';');
                }

                fclose($out);
                exit;
            }


    // -------------------------------------------------------------------
// -----------------------------------------------------------------------

}
