<?php

namespace App\Controllers\Admin\Lap;

use App\Controllers\BaseController;
use App\Models\Lap\BMPresensiSiswaModel;
use App\Models\Lap\BMKelasModel;
use App\Models\Lap\BMSiswaModel;
use App\Models\HariLiburModel;

class LapControllerBulananHadir extends BaseController
{
    protected $presensiModel;
    protected $kelasModel;
    protected $siswaModel;
    protected $hariLiburModel;

    public function __construct()
    {
        $this->presensiModel  = new BMPresensiSiswaModel();
        $this->kelasModel     = new BMKelasModel();
        $this->siswaModel     = new BMSiswaModel();
        $this->hariLiburModel = new HariLiburModel();
    }

    public function index()
    {
        // =========================
        // FILTER
        // =========================
        $bulan   = $this->request->getGet('bulan') ?? date('Y-m');
        $idKelas = $this->request->getGet('kelas') ?? 'all';

        // =========================
        // JUMLAH HARI DALAM BULAN
        // =========================
        $days = (int) date('t', strtotime($bulan));

        // =========================
        // DATA MASTER KELAS
        // =========================
        $kelasList = $this->kelasModel->getKelas();

        // =========================
        // DATA SISWA
        // =========================
        $siswaList = ($idKelas === 'all')
            ? $this->siswaModel->getSiswaWithKelas()
            : $this->siswaModel->getSiswaByKelas($idKelas);

        // =========================
        // DATA PRESENSI BULANAN (MATRIX)
        // =========================
        $matrix = $this->presensiModel
            ->getPresensiBulananMatrix($bulan, $idKelas);

        // =========================
        // DATA HARI LIBUR (YYYY-MM)
        // =========================
        $libur = $this->hariLiburModel
            ->where("DATE_FORMAT(tanggal, '%Y-%m')", $bulan)
            ->findAll();

        /**
         * Bentuk array:
         * [
         *   '2026-02-10',
         *   '2026-02-17',
         * ]
         */
        $hariLibur = array_column($libur, 'tanggal');

        // =========================
        // KIRIM KE VIEW
        // =========================
        return view('admin/lap/lapbulananhadir', [
            'title'         => 'LAPORAN HADIR BULANAN',
            'bulan'         => $bulan,
            'days'          => $days,
            'kelasList'     => $kelasList,
            'selectedKelas' => $idKelas,
            'siswa'         => $siswaList,
            'matrix'        => $matrix,
            'hariLibur'     => $hariLibur, // 🔥 dipakai di view
        ]);
    }
}
