<?php

namespace App\Controllers\Admin\Lap;

use App\Controllers\BaseController;
use App\Models\Lap\MPresensiSiswaModel;
use App\Models\Lap\MKelasModel;
use App\Models\Lap\MSiswaModel;

class LapControllerMingguan extends BaseController
{
    protected $presensiModel;
    protected $kelasModel;
    protected $siswaModel;

    public function __construct()
    {
        $this->presensiModel = new MPresensiSiswaModel();
        $this->kelasModel    = new MKelasModel();
        $this->siswaModel    = new MSiswaModel();
    }

    public function index()
    {
        // Ambil filter
        $tanggalAwal  = $this->request->getGet('tanggal_awal')  ?? date('Y-m-d', strtotime('monday this week'));
        $tanggalAkhir = $this->request->getGet('tanggal_akhir') ?? date('Y-m-d', strtotime('sunday this week'));
        $idKelas      = $this->request->getGet('kelas')          ?? 'all';
        $status       = $this->request->getGet('status')        ?? 'all';

        $kelasList = $this->kelasModel->getKelas();
        $laporan   = [];

        // Ambil siswa sesuai kelas
        $siswaList = ($idKelas === 'all') 
            ? $this->siswaModel->getSiswaWithKelas() 
            : $this->siswaModel->getSiswaByKelas($idKelas);

        // Ambil presensi sesuai rentang
        $presensiList = $this->presensiModel->getPresensiByTanggalRange($tanggalAwal, $tanggalAkhir, $idKelas);

        // Map presensi per siswa
        $presensiMap = [];
        foreach ($presensiList as $p) {
            $presensiMap[$p['id_siswa']][] = $p;
        }

        // Hitung per siswa
        foreach ($siswaList as $s) {
            $presensiSiswa = $presensiMap[$s['id_siswa']] ?? [];

            $hadir = $sakit = $izin = $alpa = $terlambat = $tidakSolat = 0;

            if (!empty($presensiSiswa)) {
                foreach ($presensiSiswa as $p) {
                    $kehadiran = $p['id_kehadiran'] ?? '4';

                    switch($kehadiran){
                        case '1':
                            $hadir++;
                            if (!empty($p['jam_masuk']) && $p['jam_masuk'] > '07:00:00') $terlambat++;
                            if (empty($p['jam_sholat'])) $tidakSolat++;
                            break;
                        case '2': $sakit++; break;
                        case '3': $izin++; break;
                        default: $alpa++;
                    }
                }
            } else {
                $alpa = 1;
            }

            $row = [
                'id_siswa'    => $s['id_siswa'],
                'nis'         => $s['nis'] ?? '-',
                'nama_siswa'  => $s['nama_siswa'],
                'jk'          => $s['jenis_kelamin'] ?? '-',
                'kelas'       => $s['nama_kelas'] ?? '-',
                'hadir'       => $hadir,
                'sakit'       => $sakit,
                'izin'        => $izin,
                'alpa'        => $alpa,
                'terlambat'   => $terlambat,
                'tidak_solat' => $tidakSolat,
            ];

            // Filter berdasarkan status card
            if ($status !== 'all') {
                if ($status === 'terlambat' && $terlambat == 0) continue;
                if ($status === 'tidak_solat' && $tidakSolat == 0) continue;
                if (in_array($status,['1','2','3','4']) && $row[$this->statusField($status)] == 0) continue;
            }

            $laporan[] = $row;
        }

        // Hitung summary untuk card
        $summary = [
            'hadir'      => 0,
            'sakit'      => 0,
            'izin'       => 0,
            'alpa'       => 0,
            'terlambat'  => 0,
            'tidak_solat'=> 0,
            'total'      => count($siswaList),
        ];

        foreach ($siswaList as $s) {
            $presensiSiswa = $presensiMap[$s['id_siswa']] ?? [];

            $h = $sakit = $izin = $alpa = $terlambat = $tidakSolat = 0;

            if (!empty($presensiSiswa)) {
                foreach ($presensiSiswa as $p) {
                    $kehadiran = $p['id_kehadiran'] ?? '4';
                    switch($kehadiran){
                        case '1':
                            $h++;
                            if (!empty($p['jam_masuk']) && $p['jam_masuk']>'07:00:00') $terlambat++;
                            if (empty($p['jam_sholat'])) $tidakSolat++;
                            break;
                        case '2': $sakit++; break;
                        case '3': $izin++; break;
                        default: $alpa++;
                    }
                }
            } else { $alpa = 1; }

            $summary['hadir'] += $h;
            $summary['sakit'] += $sakit;
            $summary['izin'] += $izin;
            $summary['alpa'] += $alpa;
            $summary['terlambat'] += $terlambat;
            $summary['tidak_solat'] += $tidakSolat;
        }

        return view('admin/lap/lapmingguan', [
            'title'         => 'LAPORAN PRESENSI MINGGUAN',
            'laporan'       => $laporan,
            'kelasList'     => $kelasList,
            'selectedKelas' => $idKelas,
            'tanggalAwal'   => $tanggalAwal,
            'tanggalAkhir'  => $tanggalAkhir,
            'summary'       => $summary,
        ]);
    }

    private function statusField($status){
        return match($status){
            '1'=>'hadir',
            '2'=>'sakit',
            '3'=>'izin',
            '4'=>'alpa',
            default=>'hadir'
        };
    }

public function exportCSV()
{
    $tanggalAwal  = $this->request->getGet('tanggal_awal');
    $tanggalAkhir = $this->request->getGet('tanggal_akhir');
    $idKelas      = $this->request->getGet('kelas') ?? 'all';
    $status       = $this->request->getGet('status') ?? 'all';

    if (!$tanggalAwal || !$tanggalAkhir) {
        return redirect()->back()->with('error', 'Tanggal tidak lengkap');
    }

    // ===== LOGIC SAMA PERSIS DENGAN index() =====

    $siswaList = ($idKelas === 'all') 
        ? $this->siswaModel->getSiswaWithKelas() 
        : $this->siswaModel->getSiswaByKelas($idKelas);

    $presensiList = $this->presensiModel
        ->getPresensiByTanggalRange($tanggalAwal, $tanggalAkhir, $idKelas);

    $presensiMap = [];
    foreach ($presensiList as $p) {
        $presensiMap[$p['id_siswa']][] = $p;
    }

    $laporan = [];

    foreach ($siswaList as $s) {
        $presensiSiswa = $presensiMap[$s['id_siswa']] ?? [];

        $hadir = $sakit = $izin = $alpa = $terlambat = $tidakSolat = 0;

        if (!empty($presensiSiswa)) {
            foreach ($presensiSiswa as $p) {
                $kehadiran = $p['id_kehadiran'] ?? '4';

                switch ($kehadiran) {
                    case '1':
                        $hadir++;
                        if (!empty($p['jam_masuk']) && $p['jam_masuk'] > '07:00:00') {
                            $terlambat++;
                        }
                        if (empty($p['jam_sholat'])) {
                            $tidakSolat++;
                        }
                        break;
                    case '2': $sakit++; break;
                    case '3': $izin++; break;
                    default:  $alpa++;
                }
            }
        } else {
            $alpa = 1;
        }

        $row = [
            'nama_siswa'  => $s['nama_siswa'],
            'kelas'       => $s['nama_kelas'] ?? '-',
            'hadir'       => $hadir,
            'sakit'       => $sakit,
            'izin'        => $izin,
            'alpa'        => $alpa,
            'terlambat'   => $terlambat,
            'tidak_solat' => $tidakSolat,
        ];

        // filter status (jika dipakai)
        if ($status !== 'all') {
            if ($status === 'terlambat' && $terlambat == 0) continue;
            if ($status === 'tidak_solat' && $tidakSolat == 0) continue;
            if (in_array($status, ['1','2','3','4']) && $row[$this->statusField($status)] == 0) continue;
        }

        $laporan[] = $row;
    }

    // ===== EXPORT CSV =====

    $filename = "Rekap_Mingguan_{$tanggalAwal}_{$tanggalAkhir}.csv";

    header('Content-Type: text/csv; charset=UTF-8');
    header("Content-Disposition: attachment; filename=\"$filename\"");
    echo "\xEF\xBB\xBF";

    $output = fopen('php://output', 'w');

    fputcsv($output, [
        'No',
        'Nama Siswa',
        'Kelas',
        'Hadir',
        'Sakit',
        'Izin',
        'Alpa',
        'Terlambat',
        'Tidak Solat'
    ], ';');

    $no = 1;
    foreach ($laporan as $r) {
        fputcsv($output, [
            $no++,
            $r['nama_siswa'],
            $r['kelas'],
            $r['hadir'],
            $r['sakit'],
            $r['izin'],
            $r['alpa'],
            $r['terlambat'],
            $r['tidak_solat'],
        ], ';');
    }

    fclose($output);
    exit;
}






}
