<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\GuruModel;
use App\Models\SiswaModel;
use App\Models\KelasModel;
use App\Models\PetugasModel;
use App\Models\PresensiGuruModel;
use App\Models\PresensiSiswaModel;
use CodeIgniter\I18n\Time;

class MenuPersentasi extends BaseController
{
    protected $siswaModel;
    protected $guruModel;
    protected $kelasModel;
    protected $presensiSiswaModel;
    protected $presensiGuruModel;
    protected $petugasModel;

    public function __construct()
    {
        $this->siswaModel         = new SiswaModel();
        $this->guruModel          = new GuruModel();
        $this->kelasModel         = new KelasModel();
        $this->presensiSiswaModel = new PresensiSiswaModel();
        $this->presensiGuruModel  = new PresensiGuruModel();
        $this->petugasModel       = new PetugasModel();
    }

    public function index()
    {
        $now    = Time::now('Asia/Jakarta');
        $today = $now->toDateString();

        /* ===============================
         * DATA KEHADIRAN SISWA (AMAN)
         * =============================== */
        $hadir = count($this->presensiSiswaModel->getPresensiByKehadiran('1', $today));
        $sakit = count($this->presensiSiswaModel->getPresensiByKehadiran('2', $today));
        $izin  = count($this->presensiSiswaModel->getPresensiByKehadiran('3', $today));
        $alfa  = count($this->presensiSiswaModel->getPresensiByKehadiran('4', $today));

        $totalSiswa = $hadir + $sakit + $izin + $alfa;
        $persentaseHadir = ($totalSiswa > 0)
            ? round(($hadir / $totalSiswa) * 100, 1)
            : 0;

        /* ===============================
         * DATA KE VIEW
         * =============================== */
        $data = [
            'title' => 'Persentase Kehadiran',
            'ctx'   => 'menupersentasi',

            'dateNow' => $now->toLocalizedString('d MMMM Y'),

            'jumlahKehadiranSiswa' => [
                'hadir' => $hadir,
                'sakit' => $sakit,
                'izin'  => $izin,
                'alfa'  => $alfa,
            ],

            'totalSiswa'       => $totalSiswa,
            'persentaseHadir'  => $persentaseHadir,

            'kelas'   => $this->kelasModel->getDataKelas(),
            'siswa'   => $this->siswaModel->getAllSiswaWithKelas(),
            'guru'    => $this->guruModel->getAllGuru(),
            'petugas' => $this->petugasModel->getAllPetugas(),
        ];

        return view('admin/menupersentasi', $data);
    }




    public function livePersentase()
{
    $today = Time::now('Asia/Jakarta')->toDateString();

    $hadir = count($this->presensiSiswaModel->getPresensiByKehadiran('1', $today));
    $sakit = count($this->presensiSiswaModel->getPresensiByKehadiran('2', $today));
    $izin  = count($this->presensiSiswaModel->getPresensiByKehadiran('3', $today));
    $alfa  = count($this->presensiSiswaModel->getPresensiByKehadiran('4', $today));

    $total = $hadir + $sakit + $izin + $alfa;
    $persen = ($total > 0) ? round(($hadir / $total) * 100, 1) : 0;

    return $this->response->setJSON([
        'hadir'      => $hadir,
        'sakit'      => $sakit,
        'izin'       => $izin,
        'alfa'       => $alfa,
        'total'      => $total,
        'persentase' => $persen,
        'time'       => date('H:i:s')
    ]);
}

}
