<?php

namespace App\Controllers\Admin\Menus;

use App\Controllers\BaseController;
use App\Models\Menus\MenusModel;

class MenusControl extends BaseController
{
    protected $menusModel;

    public function __construct()
    {
        $this->menusModel = new MenusModel();
    }

    // Tampil halaman menu
    public function index()
    {
        $data = [
            'menus' => $this->menusModel->findAll(),
            'title' => 'Kelola Menu',
            'ctx'   => 'menus'
        ];
        return view('admin/menus/index', $data);
    }

    // Tambah menu baru
    public function store()
    {
        $roles = $this->request->getPost('roles');

        $this->menusModel->save([
            'label' => $this->request->getPost('label'),
            'icon' => $this->request->getPost('icon'),
            'url' => $this->request->getPost('url'),
            'ctx' => $this->request->getPost('ctx'),
            'roles' => is_array($roles) ? implode(',', $roles) : $roles,
            'urutan' => $this->request->getPost('urutan'),
            'is_active' => $this->request->getPost('is_active') ?? 1,
            'sidebar_color' => $this->request->getPost('sidebar_color') ?? 'rose'
        ]);

        return redirect()->to('/admin/menus')
            ->with('success', 'Menu berhasil ditambahkan');
    }

    // Update menu
    public function update($id)
    {
        $roles = $this->request->getPost('roles');

        $this->menusModel->update($id, [
            'label' => $this->request->getPost('label'),
            'icon' => $this->request->getPost('icon'),
            'url' => $this->request->getPost('url'),
            'ctx' => $this->request->getPost('ctx'),
            'roles' => is_array($roles) ? implode(',', $roles) : $roles,
            'urutan' => $this->request->getPost('urutan'),
            'is_active' => $this->request->getPost('is_active') ?? 1,
            'sidebar_color' => $this->request->getPost('sidebar_color') ?? 'rose'
        ]);

        return redirect()->to('/admin/menus')
            ->with('success', 'Menu berhasil diupdate');
    }

    // Hapus menu
    public function delete($id)
    {
        $this->menusModel->delete($id);

        return redirect()->to('/admin/menus')
            ->with('success', 'Menu berhasil dihapus');
    }
}
