<?php

namespace App\Controllers\Admin\Pelanggaran;

use App\Controllers\BaseController;
use App\Models\Pelanggaran\InputJenisPelanggaranModel;

class InputJenisPelanggaran extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new InputJenisPelanggaranModel();
    }

    // LIST semua jenis pelanggaran
    public function index()
    {
        $data = [
            'title' => 'Jenis Pelanggaran',
            'jenisPelanggaran' => $this->model->orderBy('nama', 'ASC')->findAll()
        ];

        return view('admin/pelanggaran/inputjenispelanggaran', $data);
    }

    // TAMBAH pelanggaran
    public function simpan()
    {
        $this->model->save([
            'nama' => $this->request->getPost('nama'),
            'poin' => $this->request->getPost('poin')
        ]);

        return redirect()->back()->with('success', 'Jenis pelanggaran ditambahkan');
    }

    // EDIT form + simpan update
    public function edit($id)
    {
        $this->model->update($id, [
            'nama' => $this->request->getPost('nama'),
            'poin' => $this->request->getPost('poin')
        ]);

        return redirect()->back()->with('success', 'Jenis pelanggaran diperbarui');
    }

    // HAPUS
    public function hapus($id)
    {
        $this->model->delete($id);
        return redirect()->back()->with('success', 'Jenis pelanggaran dihapus');
    }
}
