<?php

namespace App\Controllers\Admin\Pelanggaran;

use App\Controllers\BaseController;
use App\Models\Pelanggaran\SiswaModel;

class PelanggaranAjaxController extends BaseController
{
    protected $siswa;

    public function __construct()
    {
        $this->siswa = new SiswaModel();
    }

    public function siswaByKelas($id_kelas)
    {
        return $this->response->setJSON(
            $this->siswa
                ->select('id_siswa, nama_siswa')
                ->where('id_kelas', $id_kelas)
                ->orderBy('nama_siswa', 'ASC')
                ->findAll()
        );
    }
}
