<?php

namespace App\Controllers\Admin\Pelanggaran;

use App\Controllers\BaseController;
use App\Models\Pelanggaran\PelanggaranSiswaModel;
use App\Models\Pelanggaran\JenisPelanggaranSiswaModel;
use App\Models\Pelanggaran\KelasModel;

class PelanggaranSiswaController extends BaseController
{
    protected $pelanggaran;
    protected $jenis;
    protected $kelas;

    public function __construct()
    {
        $this->pelanggaran = new PelanggaranSiswaModel();
        $this->jenis       = new JenisPelanggaranSiswaModel();
        $this->kelas       = new KelasModel();
    }

    public function index()
    {
        $data = $this->pelanggaran->getAll();

        return view('admin/pelanggaran/index', [
            'title' => 'Data Pelanggaran Siswa',
            'data'  => $data
        ]);
    }

    public function tambah()
    {
        return view('admin/pelanggaran/tambah', [
            'title' => 'Tambah Pelanggaran',
            'kelas' => $this->kelas->orderBy('kelas', 'ASC')->findAll(),
            'jenis' => $this->jenis->orderBy('nama', 'ASC')->findAll()
        ]);
    }

public function simpan()
{
    $jenis = $this->jenis->find($this->request->getPost('id_jenis'));

    if (!$jenis) {
        return redirect()->back()->with('error', 'Jenis pelanggaran tidak valid');
    }

    $this->pelanggaran->insert([
        'id_siswa'          => $this->request->getPost('id_siswa'),
        'jenis_pelanggaran' => $jenis['nama'],
        'poin'              => $jenis['poin'],
        'keterangan'        => $this->request->getPost('keterangan'),
        'tanggal'           => date('Y-m-d'),
        'id_guru'           => session('id_guru')
    ]);

    return redirect()->to(base_url('admin/pelanggaran'))
        ->with('success', 'Pelanggaran berhasil disimpan');
}

}
