<?php

namespace App\Controllers\Admin\Pelanggaran;

use App\Controllers\BaseController;
use App\Models\Pelanggaran\PelanggaranModel;
use App\Models\Pelanggaran\KelasModel;

class RekapController extends BaseController
{
    protected $pelanggaran;
    protected $kelas;

    public function __construct()
    {
        $this->pelanggaran = new PelanggaranModel();
        $this->kelas       = new KelasModel();
    }

    public function index()
    {
        // ambil dari ?id_kelas= (samakan dengan view)
        $id_kelas = $this->request->getGet('id_kelas');

        return view('admin/pelanggaran/rekap_index', [
            'title'    => 'Rekap Poin Pelanggaran',
            'kelas'    => $this->kelas->findAll(),
            'rekap'    => $this->pelanggaran->rekapPoin($id_kelas),
            'id_kelas' => $id_kelas
        ]);
    }
}
