<?php

namespace App\Controllers\Admin\Piket;

use App\Controllers\BaseController;
use App\Models\Piket\IzinSiswaModel;

class CetakLaporan extends BaseController
{
    protected $izinModel;

    public function __construct()
    {
        $this->izinModel = new IzinSiswaModel();
    }

    /**
     * Cetak surat izin siswa
     * URL: admin/piket/suratizin/cetak/{id}
     */
    public function index($id)
    {
        $izin = $this->izinModel->getWithSiswaById($id);

        if (!$izin) {
            return redirect()->back()->with('error', 'Data izin tidak ditemukan');
        }

        return view('admin/piket/cetaklaporan', [
            'izin' => $izin
        ]);
    }
}
