<?php

namespace App\Controllers\Admin\Piket;

use App\Controllers\BaseController;
use App\Models\Piket\IzinSiswaModel;
use App\Models\Piket\SiswaModel;
use App\Models\Piket\KelasModel;

class RekapIzinSiswa extends BaseController
{
    protected $izinModel;
    protected $siswaModel;
    protected $kelasModel;

    public function __construct()
    {
        $this->izinModel = new IzinSiswaModel();
        $this->siswaModel = new SiswaModel();
        $this->kelasModel = new KelasModel();
    }

    public function index()
    {
        $kelasId = $this->request->getGet('kelas');
        $jurusanId = $this->request->getGet('jurusan');

        // Ambil semua izin
        $dataIzin = $this->izinModel->getWithSiswa();

        // Filter berdasarkan kelas/jurusan jika ada
        if (!empty($kelasId)) {
            $dataIzin = array_filter($dataIzin, fn($i) => $i['id_kelas'] == $kelasId);
        }

        // Hitung jumlah izin per siswa
        $rekap = [];
        foreach ($dataIzin as $izin) {
            $id = $izin['id_siswa'];
            if (!isset($rekap[$id])) {
                $rekap[$id] = [
                    'nama_siswa' => $izin['nama_siswa'],
                    'kelas' => $izin['kelas'],
                    'total_izin' => 0,
                    'detail' => []
                ];
            }
            $rekap[$id]['total_izin'] += 1;
            $rekap[$id]['detail'][] = [
                'tanggal' => $izin['tanggal'],
                'jenis' => $izin['jenis'],
                'keterangan' => $izin['keterangan']
            ];
        }

        // Urutkan berdasarkan total izin terbanyak
        usort($rekap, fn($a,$b) => $b['total_izin'] <=> $a['total_izin']);

        $data = [
            'title' => 'Rekap Izin Siswa',
            'rekap' => $rekap,
            'kelasList' => $this->kelasModel->getAllKelas(),
            'selectedKelas' => $kelasId,
            'selectedJurusan' => $jurusanId
        ];

        return view('admin/piket/rekapizinsiswa', $data);
    }

    public function exportCSV()
{
    // Ambil filter dari GET (sama seperti di View)
    $kelasId = $this->request->getGet('kelas');

    // Ambil data izin + nama siswa
    $dataIzin = $this->izinModel->getWithSiswa();

    // Filter berdasarkan kelas jika dipilih
    if (!empty($kelasId)) {
        $dataIzin = array_filter($dataIzin, fn($i) => $i['id_kelas'] == $kelasId);
    }

    // Kelompokkan izin per siswa (satu baris per siswa)
    $rekap = [];
    foreach ($dataIzin as $izin) {
        $id = $izin['id_siswa'];
        if (!isset($rekap[$id])) {
            $rekap[$id] = [
                'Nama Siswa' => $izin['nama_siswa'],
                'Detail' => []
            ];
        }
        // Simpan setiap izin dalam array sederhana
        $rekap[$id]['Detail'][] = [
            'Tanggal' => $izin['tanggal'],
            'Jenis' => $izin['jenis'],
            'Keterangan' => $izin['keterangan']
        ];
    }

    // Tentukan jumlah izin terbanyak untuk header
    $maxIzin = 0;
    foreach ($rekap as $r) {
        $maxIzin = max($maxIzin, count($r['Detail']));
    }

    // Header CSV: Nama Siswa + kolom detail berurutan
    $header = ['Nama Siswa'];
    for ($i = 1; $i <= $maxIzin; $i++) {
        $header[] = "Tanggal $i";
        $header[] = "Jenis $i";
        $header[] = "Keterangan $i";
    }

    $filename = "rekap_izin_" . date('Ymd_His') . ".csv";
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename="' . $filename . '"');
    echo "\xEF\xBB\xBF"; // BOM UTF-8 agar Excel tidak kacau

    $output = fopen('php://output', 'w');
    fputcsv($output, $header, ';');

    // Isi CSV: satu baris per siswa, kolom berurutan per izin
    foreach ($rekap as $r) {
        $row = [$r['Nama Siswa']];

        foreach ($r['Detail'] as $d) {
            $row[] = $d['Tanggal'];
            $row[] = $d['Jenis'];
            $row[] = $d['Keterangan'];
        }

        // Tambahkan kolom kosong jika siswa punya izin lebih sedikit dari max
        $diff = $maxIzin - count($r['Detail']);
        for ($j = 0; $j < $diff; $j++) {
            $row[] = '';
            $row[] = '';
            $row[] = '';
        }

        fputcsv($output, $row, ';');
    }

    fclose($output);
    exit;
}


}
