<?php

namespace App\Controllers\Admin\Piket;

use App\Controllers\BaseController;
use App\Models\Piket\IzinSiswaModel;
use App\Models\Piket\SiswaModel;
use App\Models\Piket\KelasModel;

class SuratIzinController extends BaseController
{
    protected $model;

    public function __construct()
    {
        $this->model = new IzinSiswaModel();
    }

        public function index()
        {
            return view('admin/piket/suratizin', [
                'title' => 'Izin Siswa',
                'ctx' => 'suratpiketadm',
                'data'  => $this->model->getWithSiswa(),

                'kelas' => (new KelasModel())->findAll(),
                'siswa' => (new SiswaModel())->findAll(),
            ]);
        }

public function simpan()
{
    $id_siswa   = $this->request->getPost('id_siswa');
    $id_kelas   = $this->request->getPost('id_kelas');
    $tanggal = $this->request->getPost('tanggal') ?? date('Y-m-d');
    // $tanggal    = $this->request->getPost('tanggal');
    $jenis      = $this->request->getPost('jenis');
    $keterangan = $this->request->getPost('keterangan');

    // Validasi wajib
    if(empty($id_siswa) || empty($id_kelas) || empty($tanggal) || empty($jenis)){
        return $this->response->setJSON([
            'success' => false,
            'error' => 'Data tidak lengkap, pastikan semua field diisi.'
        ]);
    }

    $this->model->insert([
        'id_siswa'   => $id_siswa,
        'id_kelas'   => $id_kelas,
        'tanggal'    => $tanggal,
        'jam'        => date('H:i:s'),
        'jenis'      => $jenis,
        'keterangan' => $keterangan ?? '',
        'status'     => 'menunggu',
        'id_guru'    => session('id_guru')
    ]);

    return $this->response->setJSON([
        'success' => true
    ]);
}






        public function setujui($id)
        {
            $this->model->update($id, [
                'status' => 'disetujui'
            ]);

            return redirect()->back()
                ->with('success', 'Izin siswa berhasil disetujui');
        }

}
