<?php

namespace App\Controllers\Admin\QrDownload;

use App\Controllers\BaseController;

use App\Models\QrDownload\GuruModel;
use App\Models\QrDownload\KelasModel;
use App\Models\QrDownload\SiswaModel;

class GenerateQR extends BaseController
{
   protected SiswaModel $siswaModel;
   protected KelasModel $kelasModel;

   protected GuruModel $guruModel;

   public function __construct()
   {
      $this->siswaModel = new SiswaModel();
      $this->kelasModel = new KelasModel();

      $this->guruModel = new GuruModel();
   }

   public function index()
   {
      $siswa = $this->siswaModel->getAllSiswaWithKelas();
      $kelas = $this->kelasModel->getDataKelas();
      $guru = $this->guruModel->getAllGuru();

      $data = [
         'title' => 'Generate QR Code',
         'ctx' => 'qr',
         'siswa' => $siswa,
         'kelas' => $kelas,
         'guru' => $guru
      ];

      return view('admin/qrdownload/generate-qr', $data);
   }

   public function getSiswaByKelas()
   {
      $idKelas = $this->request->getVar('idKelas');

      $siswa = $this->siswaModel->getSiswaByKelas($idKelas);

      return $this->response->setJSON($siswa);
   }
}
