<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\RekapModel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Rekap extends BaseController
{
    protected $rekapModel;

    public function __construct()
    {
        $this->rekapModel = new RekapModel();
    }

    public function export()
    {
        $id_kelas = $this->request->getGet('kelas');
        $tanggal  = $this->request->getGet('tanggal');

        if (!$id_kelas || !$tanggal) {
            return redirect()->back()->with('error', 'Kelas dan tanggal wajib diisi');
        }

        $data = $this->rekapModel->getData($id_kelas, $tanggal);

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        $sheet->setCellValue('A1', 'No');
        $sheet->setCellValue('B1', 'Nama');
        $sheet->setCellValue('C1', 'JK');
        $sheet->setCellValue('D1', 'Kelas');
        $sheet->setCellValue('E1', 'Masuk');
        $sheet->setCellValue('F1', 'Duhur');
        $sheet->setCellValue('G1', 'Keluar');
        $sheet->setCellValue('H1', 'Status');

        $row = 2;
        $no  = 1;
        foreach ($data as $d) {
            $sheet->setCellValue('A'.$row, $no++);
            $sheet->setCellValue('B'.$row, $d['nama_siswa']);
            $sheet->setCellValue('C'.$row, $d['jenis_kelamin']);
            $sheet->setCellValue('D'.$row, $d['kelas']);
            $sheet->setCellValue('E'.$row, $d['jam_masuk'] ?? '-');
            $sheet->setCellValue('F'.$row, $d['jam_sholat'] ?? '-');
            $sheet->setCellValue('G'.$row, $d['jam_keluar'] ?? '-');
            $sheet->setCellValue('H'.$row, $d['kehadiran'] ?? '-');
            $row++;
        }

        foreach (range('A','H') as $col) {
            $sheet->getColumnDimension($col)->setAutoSize(true);
        }

        $filename = 'Rekap_Presensi_'.$tanggal.'.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'.$filename.'"');
        header('Cache-Control: max-age=0');

        $writer = new Xlsx($spreadsheet);
        $writer->save('php://output');
        exit;
    }
}
