<?php

namespace App\Controllers\Admin;

use CodeIgniter\Controller;

class RestoreController extends Controller
{
    protected $db;
    protected $sidebarMenus = [
        ['ctx' => 'dashboard', 'label' => 'Dashboard', 'icon' => 'dashboard', 'url' => 'admin/dashboard', 'children' => []],
        ['ctx' => 'backup', 'label' => 'Backup Database', 'icon' => 'backup', 'url' => 'admin/backup', 'children' => []],
        ['ctx' => 'restore', 'label' => 'Restore Database', 'icon' => 'restore', 'url' => 'admin/restore', 'children' => []],
    ];

    public function __construct()
    {
        $this->db = \Config\Database::connect();
    }

    public function index()
    {
        $data['title'] = 'Restore Database';
        $data['sidebarMenus'] = $this->sidebarMenus;

        return view('admin/restore/restore', $data);
    }

    public function run()
    {
        $file = $this->request->getFile('sql_file');

        if (!$file || !$file->isValid()) {
            return redirect()->back()->with('error', 'File tidak valid!')->withInput();
        }

        if (strtolower($file->getClientExtension()) !== 'sql') {
            return redirect()->back()->with('error', 'Hanya file .sql yang diperbolehkan.')->withInput();
        }

        $sqlContent = file_get_contents($file->getTempName());

        try {
            // Matikan foreign key sementara
            $this->db->query("SET FOREIGN_KEY_CHECKS = 0;");

            // Ambil semua tabel yang ada
            $tables = $this->db->listTables();

            // DROP semua tabel sebelum restore
            foreach ($tables as $table) {
                $this->db->query("DROP TABLE IF EXISTS `$table`;");
            }

            // Jalankan SQL dari file
            $lines = explode("\n", $sqlContent);
            $query = '';

            foreach ($lines as $line) {
                $line = trim($line);

                // Lewati komentar
                if ($line === '' || str_starts_with($line, '--') || str_starts_with($line, '/*') || str_starts_with($line, '#')) {
                    continue;
                }

                $query .= $line . " ";

                if (str_ends_with($line, ';')) {
                    $this->db->query($query);
                    $query = '';
                }
            }

            // Aktifkan kembali foreign key
            $this->db->query("SET FOREIGN_KEY_CHECKS = 1;");

            return redirect()->back()->with('success', 'Restore berhasil dilakukan!');

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Restore gagal: ' . $e->getMessage());
        }
    }
}
