<?php

namespace App\Controllers\Admin\RoolSeting;

use App\Controllers\BaseController;
use App\Models\RoolSeting\RoleRouteModel;

class RoleRouteController extends BaseController
{
    protected $roleRouteModel;

    public function __construct()
    {
        $this->roleRouteModel = new RoleRouteModel();
    }

    // ======================
    // INDEX
    // ======================
    public function index()
    {
        $data = [
            
        'title' => 'Role Route Setting',
        'ctx' => 'roleroute',
            'routes' => $this->roleRouteModel->findAll()
        ];

        return view('admin/roolseting/index', $data);
    }

    // ======================
    // CREATE
    // ======================
    public function create()
    {
        return view('admin/roolseting/form', [
            'title' => 'Tambah Role Route'
        ]);
    }

    // ======================
    // STORE
    // ======================
    public function store()
    {
        $this->roleRouteModel->save([
            'route'         => $this->request->getPost('route'),
            'allowed_roles' => $this->request->getPost('allowed_roles')
        ]);

        return redirect()->to(base_url('admin/roolseting/role-route'))
            ->with('success', 'Data berhasil disimpan');
    }

    // ======================
    // EDIT
    // ======================
    public function edit($id)
    {
        $data = [
            'title' => 'Edit Role Route',
            'row'   => $this->roleRouteModel->find($id)
        ];

        return view('admin/roolseting/form', $data);
    }

    // ======================
    // UPDATE
    // ======================
    public function update($id)
    {
        $this->roleRouteModel->update($id, [
            'route'         => $this->request->getPost('route'),
            'allowed_roles' => $this->request->getPost('allowed_roles')
        ]);

        return redirect()->to(base_url('admin/roolseting/role-route'))
            ->with('success', 'Data berhasil diupdate');
    }

    // ======================
    // DELETE
    // ======================
    public function delete($id)
    {
        $this->roleRouteModel->delete($id);

        return redirect()->back()->with('success', 'Data berhasil dihapus');
    }
}
