<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\SiswaModel;
use App\Models\KelasModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Siswa extends BaseController
{
    protected $siswaModel;
    protected $kelasModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
        $this->kelasModel  = new KelasModel();
    }

    /* =====================================================
     * FORM EDIT UNIQUE CODE
     * URL : /admin/siswa/edit-code/{id_siswa}
     * ===================================================== */
    public function editCode($id)
    {
        $id = (int) $id;

        $siswa = $this->siswaModel->getSiswaById($id);

        if (!$siswa) {
            throw new PageNotFoundException('Data siswa tidak ditemukan');
        }

        return view('admin/siswa/edit_unique_code', [
            'title' => 'Edit Unique Code',
            'siswa' => $siswa
        ]);
    }

    /* =====================================================
     * PROSES UPDATE UNIQUE CODE
     * URL : /admin/siswa/update-code/{id_siswa}
     * ===================================================== */
    public function updateCode($id)
    {
        $id = (int) $id;

        $siswa = $this->siswaModel->getSiswaById($id);
        if (!$siswa) {
            throw new PageNotFoundException('Data siswa tidak ditemukan');
        }

        // ===================== VALIDASI =====================
        $rules = [
            'unique_code' => [
                'label' => 'Unique Code',
                'rules' => 'required|min_length[6]|is_unique[tb_siswa.unique_code,id_siswa,' . $id . ']',
                'errors' => [
                    'required'   => 'Unique Code wajib diisi',
                    'min_length' => 'Minimal 6 karakter',
                    'is_unique'  => 'Unique Code sudah digunakan siswa lain'
                ]
            ]
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()
                ->withInput()
                ->with('errors', $this->validator->getErrors());
        }

        // ===================== UPDATE =====================
        $this->siswaModel->update($id, [
            'unique_code' => $this->request->getPost('unique_code')
        ]);

        // ===================== REDIRECT BACK =====================
        return redirect()->to(previous_url())
            ->with('success', 'Unique Code berhasil diperbarui');
    }

    /* =====================================================
     * PILIH KELAS
     * ===================================================== */
    public function pilihKelas()
    {
        $kelas = $this->kelasModel->findAll();

        return view('admin/siswa/pilih_kelas', [
            'title' => 'Pilih Kelas',
            'kelas' => $kelas
        ]);
    }

    /* =====================================================
     * SISWA BERDASARKAN KELAS
     * ===================================================== */
    public function siswaByKelas($id_kelas)
    {
        $siswa = $this->siswaModel->getSiswaByKelas($id_kelas);

        return view('admin/siswa/index', [
            'title' => 'Data Siswa',
            'siswa' => $siswa
        ]);
    }
}
