<?php

namespace App\Controllers\Admin\Upload;

use App\Controllers\BaseController;
use App\Models\Upload\SiswaModel;
use App\Models\Upload\KelasModel;
use App\Models\Upload\JurusanModel;

class DataSiswa extends BaseController
{
    protected $siswaModel;
    protected $kelasModel;
    protected $jurusanModel;

    public function __construct()
    {
        $this->siswaModel   = new SiswaModel();
        $this->kelasModel   = new KelasModel();
        $this->jurusanModel = new JurusanModel();
    }

    // ================================
    // FORM INPUT + TAMPIL DATA SISWA
    // ================================
public function index()
{
    $data = [
        'title'   => 'Input Data Siswa',
        'ctx'     => 'datasiswa',
        'jurusan' => $this->jurusanModel->getDataJurusan(),
        'kelas'   => $this->kelasModel->getDataKelas(),
        'siswa'   => $this->siswaModel->getSiswaWithKelas(), // data sudah urut
    ];

    return view('admin/upload/datasiswa', $data);
}


    // ================================
    // SIMPAN DATA SISWA
    // ================================
    public function save()
{
    $validation = \Config\Services::validation();

    $validation->setRules([
        'nis'           => 'required|numeric',
        'nama_siswa'    => 'required|min_length[3]',
        'id_jurusan'    => 'required|numeric',
        'id_kelas'      => 'required|numeric',
        'jenis_kelamin' => 'required|in_list[Laki-laki,Perempuan]',
        'no_hp'         => 'required|numeric',
    ]);

    if (!$validation->withRequest($this->request)->run()) {
        return redirect()->back()
                         ->withInput()
                         ->with('errors', $validation->getErrors());
    }

    $nis = $this->request->getPost('nis');

    // 🔥 CEK DUPLIKAT NIS
    if ($this->siswaModel->isNisExists($nis)) {
        return redirect()->back()
                         ->withInput()
                         ->with('errors', ['NIS sudah terdaftar!']);
    }

    $data = [
        'nis'           => $nis,
        'nama_siswa'    => $this->request->getPost('nama_siswa'),
        'id_kelas'      => $this->request->getPost('id_kelas'),
        'jenis_kelamin' => $this->request->getPost('jenis_kelamin'),
        'no_hp'         => $this->request->getPost('no_hp'),
        'unique_code'   => $nis // 🔥 langsung isi disini
    ];

    $this->siswaModel->insert($data);

    session()->setFlashdata('success', 'Data siswa berhasil disimpan!');

    return redirect()->to(base_url('admin/upload/datasiswa'));
}


    // ================================
    // AJAX AMBIL KELAS BERDASARKAN JURUSAN
    // ================================
    public function getKelasByJurusan($id_jurusan)
    {
        $kelas = $this->kelasModel->getDataKelas();

        $filtered = array_filter($kelas, function ($k) use ($id_jurusan) {
            return $k['id_jurusan'] == $id_jurusan;
        });

        return $this->response->setJSON(array_values($filtered));
    }
}
