<?php

namespace App\Controllers\Admin\Upload;

use App\Controllers\BaseController;
use App\Models\Upload\JurusanModel;

class InputJurusan extends BaseController
{
    protected $jurusanModel;

    public function __construct()
    {
        $this->jurusanModel = new JurusanModel();
    }

    // =============================
    // HALAMAN INDEX
    // =============================
    public function index()
    {
        return view('admin/upload/input_jurusan', [
            'ctx'       => 'inputjurusan',
            'title'   => 'Input Jurusan',
            'jurusan' => $this->jurusanModel->getDataJurusan()
        ]);
    }

    // =============================
    // SIMPAN DATA
    // =============================
    public function store()
    {
        $namaJurusan = strtoupper(trim($this->request->getPost('jurusan')));

        if (!$namaJurusan || strlen($namaJurusan) < 3) {
            return redirect()->back()
                ->withInput()
                ->with('error', '❌ Nama jurusan minimal 3 karakter');
        }

        // CEK DUPLIKAT
        if ($this->jurusanModel->isDuplicate($namaJurusan)) {
            return redirect()->back()
                ->withInput()
                ->with('error', '❌ Nama jurusan sudah ada');
        }

        $this->jurusanModel->addJurusan([
            'jurusan' => $namaJurusan
        ]);

        return redirect()->to('/admin/upload/input-jurusan')
            ->with('success', '✅ Jurusan berhasil ditambahkan');
    }

    // =============================
    // UPDATE DATA
    // =============================
    public function update($id)
    {
        $id = (int) $id;
        $namaJurusan = strtoupper(trim($this->request->getPost('jurusan')));

        if (!$namaJurusan || strlen($namaJurusan) < 3) {
            return redirect()->back()
                ->with('error', '❌ Nama jurusan minimal 3 karakter');
        }

        // CEK DUPLIKAT KECUALI ID SENDIRI
        if ($this->jurusanModel->isDuplicate($namaJurusan, $id)) {
            return redirect()->back()
                ->with('error', '❌ Nama jurusan sudah digunakan jurusan lain');
        }

        $result = $this->jurusanModel->editJurusan($id, [
            'jurusan' => $namaJurusan
        ]);

        if ($result === 'used') {
            return redirect()->back()
                ->with('error', '❌ Jurusan sedang digunakan tabel lain');
        }

        if ($result === 'not_found') {
            return redirect()->back()
                ->with('error', '❌ Data jurusan tidak ditemukan');
        }

        return redirect()->back()
            ->with('success', '✅ Jurusan berhasil diperbarui');
    }

    // =============================
    // DELETE DATA
    // =============================
    public function delete($id)
    {
        $id = (int) $id;

        $result = $this->jurusanModel->deleteJurusan($id);

        if ($result === 'used') {
            return redirect()->back()->with(
                'error',
                '❌ Jurusan tidak dapat dihapus karena sedang digunakan tabel lain'
            );
        }

        if ($result === 'success') {
            return redirect()->back()->with(
                'success',
                '✅ Jurusan berhasil dihapus'
            );
        }

        return redirect()->back()->with(
            'error',
            '❌ Data jurusan tidak ditemukan'
        );
    }
}
