<?php

namespace App\Controllers\Admin\Upload;

use App\Controllers\BaseController;
use App\Models\Upload\KelasModel;
use App\Models\Upload\JurusanModel;
use App\Models\SiswaModel;

class InputKelas extends BaseController
{
    protected $kelasModel;
    protected $jurusanModel;
    protected $siswaModel;

    public function __construct()
    {
        $this->kelasModel   = new KelasModel();
        $this->jurusanModel = new JurusanModel();
        $this->siswaModel   = new SiswaModel();
    }

    /**
     * HALAMAN INDEX
     */
    public function index()
    {
        $kelasList = $this->kelasModel->getAllKelas();

        // Ambil semua id_kelas yang sedang dipakai di tb_siswa (sekali query saja)
        $usedKelas = $this->siswaModel
                          ->select('id_kelas')
                          ->distinct()
                          ->findAll();

        $usedIds = array_column($usedKelas, 'id_kelas');

        // Tambahkan flag is_used
        foreach ($kelasList as &$k) {
            $k['is_used'] = in_array($k['id_kelas'], $usedIds);
        }

        $data = [
            'title'         => 'Input Data Kelas',
            'ctx'       => 'inputkelas',
            'jurusan'       => $this->jurusanModel->findAll(),
            'next_id_kelas' => $this->kelasModel->getNextIdKelas(),
            'kelasList'     => $kelasList
        ];

        return view('admin/upload/input_kelas', $data);
    }

    /**
     * SIMPAN DATA
     */
    public function store()
    {
        $id_kelas   = trim($this->request->getPost('id_kelas'));
        $kelas      = trim($this->request->getPost('kelas'));
        $id_jurusan = trim($this->request->getPost('id_jurusan'));

        if ($id_kelas === '' || $kelas === '' || $id_jurusan === '') {
            return redirect()->back()
                ->with('error', 'Semua field wajib diisi');
        }

        if ($this->kelasModel->find($id_kelas)) {
            return redirect()->back()
                ->with('error', 'ID sudah digunakan!');
        }

        $this->kelasModel->insert([
            'id_kelas'   => $id_kelas,
            'kelas'      => $kelas,
            'id_jurusan' => $id_jurusan
        ]);

        return redirect()->to(base_url('admin/upload/kelas'))
            ->with('success', 'Data kelas berhasil ditambahkan');
    }

    /**
     * UPDATE DATA (TERMASUK ID)
     */
    public function update($oldId)
    {
        $id_kelas   = trim($this->request->getPost('id_kelas'));
        $kelas      = trim($this->request->getPost('kelas'));
        $id_jurusan = trim($this->request->getPost('id_jurusan'));

        if ($id_kelas === '' || $kelas === '' || $id_jurusan === '') {
            return redirect()->back()
                ->with('error', 'Semua field wajib diisi');
        }

        // Jika ID diganti
        if ($id_kelas != $oldId) {

            if ($this->kelasModel->find($id_kelas)) {
                return redirect()->back()
                    ->with('error', 'ID sudah digunakan!');
            }

            // Cek apakah kelas lama sedang dipakai siswa
            $isUsed = $this->siswaModel
                           ->where('id_kelas', $oldId)
                           ->countAllResults();

            if ($isUsed > 0) {
                return redirect()->back()
                    ->with('error', 'ID tidak bisa diubah karena kelas sedang digunakan oleh siswa.');
            }
        }

        $this->kelasModel->update($oldId, [
            'id_kelas'   => $id_kelas,
            'kelas'      => $kelas,
            'id_jurusan' => $id_jurusan
        ]);

        return redirect()->to(base_url('admin/upload/kelas'))
            ->with('success', 'Data berhasil diupdate');
    }

    /**
     * DELETE DATA
     */
    public function delete($id)
    {
        // Cek apakah kelas dipakai di tb_siswa
        $isUsed = $this->siswaModel
                       ->where('id_kelas', $id)
                       ->countAllResults();

        if ($isUsed > 0) {
            return redirect()->to(base_url('admin/upload/kelas'))
                ->with('error', 'Kelas tidak bisa dihapus karena sudah digunakan oleh data siswa.');
        }

        $this->kelasModel->delete($id);

        return redirect()->to(base_url('admin/upload/kelas'))
            ->with('success', 'Data berhasil dihapus');
    }
}
