<?php

namespace App\Controllers\Admin\Upload;

use App\Controllers\BaseController;
use App\Models\Upload\SiswaModel;

class UploadSiswa extends BaseController
{
    protected $siswaModel;

    public function __construct()
    {
        $this->siswaModel = new SiswaModel();
    }

    public function index()
    {
        return view('admin/upload/upload_siswa', [
            'title' => 'Upload Data Siswa',
            'ctx'     => 'uploadsiswa',
        ]);
    }

    // ================= PREVIEW =================
    public function preview()
    {
        $file = $this->request->getFile('file_csv');

        if (!$file || !$file->isValid()) {
            return redirect()->back()->with('error', 'File tidak valid');
        }

        $handle = fopen($file->getTempName(), 'r');
        if (!$handle) {
            return redirect()->back()->with('error', 'File tidak bisa dibaca');
        }

        $previewData = [];
        $row = 0;

        while (($data = fgetcsv($handle, 2000, ';')) !== false) {
            $row++;

            if (count($data) < 7) {
                continue;
            }

            $previewData[] = [
                'nis'           => trim($data[1]),
                'nama_siswa'    => trim($data[2]),
                'id_kelas'      => (int) trim($data[3]),
                'jenis_kelamin' => trim($data[4]),
                'no_hp'         => trim($data[5]),
                'unique_code'   => trim($data[6]),
            ];
        }

        fclose($handle);

        if (empty($previewData)) {
            return redirect()->back()->with('error', 'Data CSV kosong / format salah');
        }

        // Simpan ke session (sementara)
        session()->set('preview_siswa', $previewData);

        return view('admin/upload/preview_siswa', [
            'title' => 'Preview Data Siswa',
            'data'  => $previewData
        ]);
    }

    // ================= SAVE =================
    public function save()
    {
        $data = session()->get('preview_siswa');

        if (!$data) {
            return redirect()->to('admin/upload/siswa')->with('error', 'Session preview kosong');
        }

        $inserted = 0;

        foreach ($data as $row) {

            if ($row['nis'] === '' || $row['nama_siswa'] === '' || $row['id_kelas'] === 0) {
                continue;
            }

            // Cegah duplikat
            if ($this->siswaModel->where('nis', $row['nis'])->countAllResults() > 0) {
                continue;
            }

            $this->siswaModel->insert($row);
            $inserted++;
        }

        session()->remove('preview_siswa');

        return redirect()->to('admin/upload/siswa')
            ->with('success', "Berhasil menyimpan {$inserted} data siswa");
    }



    // ================= DOWNLOAD FORMAT CSV =================
public function downloadFormat()
{
    $filename = 'format_upload_siswa.csv';

    // Header CSV (TANPA header sesuai aturanmu)
    $content = [];
    $content[] = "1;94165336;NAMA SISWA;1;Laki-Laki;08XXXXXXXXXX;94165336";
    $content[] = "2;105920808;NAMA SISWI;1;Perempuan;08XXXXXXXXXX;105920808";

    $csv = implode("\n", $content);

    return $this->response
        ->setHeader('Content-Type', 'text/csv')
        ->setHeader('Content-Disposition', 'attachment; filename="' . $filename . '"')
        ->setBody($csv);
}

}
