<?php

namespace App\Controllers\Admin\UserLoginAktif;

use App\Controllers\BaseController;
use App\Models\UserLoginAktif\ModelUserLoginAktif;
use Myth\Auth\Password;

class UserLoginAktif extends BaseController
{
    protected $userLoginModel;

    public function __construct()
    {
        $this->userLoginModel = new ModelUserLoginAktif();
    }

    public function index()
    {
        $data = [
            'title' => 'Ganti Password',
            'ctx'   => 'userloginaktif'
        ];

        return view('admin/userloginaktif/userloginaktif', $data);
    }

    public function updatePassword()
    {
        $rules = [
            'password_lama' => 'required',
            'password_baru' => 'required|min_length[6]',
            'konfirmasi'    => 'required|matches[password_baru]',
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->withInput()
                ->with('validation', $this->validator);
        }

        $user = user(); // user login aktif

        // Cek password lama
        if (!Password::verify(
            $this->request->getVar('password_lama'),
            $user->password_hash
        )) {
            return redirect()->back()->with('error', 'Password lama salah');
        }

        // Update password
        $this->userLoginModel->updatePassword(
            $user->id,
            Password::hash($this->request->getVar('password_baru'))
        );

        return redirect()->back()->with('success', 'Password berhasil diganti');
    }
}
