<?php

namespace App\Controllers\Admin\laporan\kehadiran;

use App\Models\PresensiModel;
use App\Models\KelasModel;
use App\Models\NKelasModel;
use App\Models\SiswaModel;


use App\Controllers\BaseController;

class ControllerHSIA extends BaseController
{


//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
        
    public function dassiswahadir()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN SISWA HADIR ',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiHadir($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/siswahadir', $data);
    }
//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
// rekap siswa sakit ===================================================

        public function dassiswasakit()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN SISWA SAKIT ',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiSakit($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/siswasakit', $data);
    }


//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
// rekap siswa izin ===================================================

        public function dassiswaizin()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN SISWA IZIN ',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiIzin($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/siswaizin', $data);
    }
//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
// rekap siswa Alpa ===================================================

        public function dassiswaalpa()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN SISWA ALPA',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiharian($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/siswaalpa', $data);
    }




//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
        

        public function dassiswajml()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'DATA KEHADIRAN SISWA - SMAN 1 CIKATOMAS',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiHarian($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/jmlsiswa', $data);
    }



//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – harian  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄
    

    public function dasharian()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN PRESENSI HARIAN',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiHarian($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/rekharian', $data);
    }

//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Mingguan  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄

public function dasmingguan()
{
    $presensi = new PresensiModel();
    $kelas    = new KelasModel();

    // =============================
    // BULAN & MINGGU BERJALAN
    // =============================
    $bulan = $this->request->getGet('bulan') ?? date('Y-m');
    $minggu = $this->request->getGet('minggu');

    // 🔥 Default: minggu berjalan
    if (!$minggu) {
        $minggu = ceil(date('d') / 7);
    }

    $id_kelas = $this->request->getGet('kelas');

    // =============================
    // HITUNG RANGE TANGGAL
    // =============================
    $tahun = date('Y', strtotime($bulan));
    $bulanAngka = date('m', strtotime($bulan));

    $awalHari  = (($minggu - 1) * 7) + 1;
    $akhirHari = min($awalHari + 6, date('t', strtotime("$tahun-$bulanAngka-01")));

    $tanggalAwal  = "$tahun-$bulanAngka-" . str_pad($awalHari, 2, '0', STR_PAD_LEFT);
    $tanggalAkhir = "$tahun-$bulanAngka-" . str_pad($akhirHari, 2, '0', STR_PAD_LEFT);

    // =============================
    // AMBIL DATA
    // =============================
    $dataPresensi = $presensi->getPresensiMingguan(
        $tanggalAwal,
        $tanggalAkhir,
        $id_kelas
    );

    return view('admin/laporan/kehadiran/rekmingguan', [
        'title'    => 'LAPORAN PRESENSI MINGGUAN',
        'bulan'    => $bulan,
        'minggu'   => $minggu,
        'id_kelas' => $id_kelas,
        'kelas'    => $kelas->findAll(),
        'data'     => $dataPresensi,
    ]);
}


//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – BUlanan  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄

public function dasbulanan()
{
    $bulan    = $this->request->getGet('bulan') ?? date('Y-m');
    $id_kelas = $this->request->getGet('kelas');

    $presensi = new \App\Models\PresensiModel();
    $kelas    = new \App\Models\KelasModel();

    $data = [
        'title'    => 'LAPORAN PRESENSI BULANAN',
        'bulan'    => $bulan,
        'id_kelas' => $id_kelas,
        'kelas'    => $kelas->findAll(),
        'data'     => $presensi->getPresensiBulanan($bulan, $id_kelas),
    ];

    return view('admin/laporan/kehadiran/rekbulanan', $data);
}
//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Persiswa  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄


public function daspersiswa()
{
    $id_siswa = $this->request->getGet('siswa');
    $bulan    = $this->request->getGet('bulan') ?? date('Y-m');

    $presensi = new \App\Models\PresensiModel();
    $siswa    = new \App\Models\SiswaModel2();
    $liburModel = new \App\Models\HariLiburModel(); // Tambahkan model libur

    // Ambil semua tanggal libur dalam bentuk array ['2026-01-01', ...]
    $hariLibur = $liburModel->findColumn('tanggal');

    $dataFinal = [];
    $rekap = [
        'hadir' => 0,
        'sakit' => 0,
        'izin'  => 0,
        'alpha' => 0,
    ];

    if ($id_siswa) {

        // 1️⃣ ambil presensi dari database
        $dataDb = $presensi->getRekapPerSiswa($id_siswa, $bulan);

        // 2️⃣ index data berdasarkan tanggal
        $map = [];
        foreach ($dataDb as $row) {
            $map[$row['tanggal']] = $row;
        }

        // 3️⃣ generate tanggal 1 bulan
        $tgl = new \DateTime($bulan . '-01');
        $akhir = (clone $tgl)->modify('last day of this month');

        while ($tgl <= $akhir) {

            $tanggal = $tgl->format('Y-m-d');

            // Ambil nomor hari (1=Senin ... 7=Minggu)
            $hari = $tgl->format('N');

            // ❌ LEWATI Sabtu & Minggu
            if ($hari < 6) {

                // ❌ LEWATI HARI LIBUR
                if (in_array($tanggal, $hariLibur)) {
                    $tgl->modify('+1 day');
                    continue;
                }

                // 4️⃣ jika tidak ada data → ALPHA
                if (isset($map[$tanggal])) {
                    $row = $map[$tanggal];
                } else {
                    $row = [
                        'tanggal'    => $tanggal,
                        'jam_masuk'  => null,
                        'jam_keluar' => null,
                        'kehadiran'  => null,
                        'keterangan' => null,
                    ];
                }

                // 5️⃣ hitung rekap
                if ($row['kehadiran'] === 'Hadir') {
                    $rekap['hadir']++;
                } elseif ($row['kehadiran'] === 'Sakit') {
                    $rekap['sakit']++;
                } elseif ($row['kehadiran'] === 'Izin') {
                    $rekap['izin']++;
                } else {
                    $rekap['alpha']++;
                }

                $dataFinal[] = $row;
            }

            $tgl->modify('+1 day');
        }
    }

    return view('admin/laporan/kehadiran/rekpersiswa', [
        'title'     => 'LAPORAN PRESENSI PERSISWA',
        'bulan'     => $bulan,
        'siswaList' => $siswa->getSiswaWithKelas(),
        'siswa'     => $id_siswa ? $siswa->find($id_siswa) : null,
        'data'      => $dataFinal,
        'rekap'     => $rekap,
    ]);
}

//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Belum Absen  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄

            public function belumabsen()
        {
            $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
            $id_kelas = $this->request->getGet('kelas');

            $presensi = new PresensiModel();
            $kelas    = new KelasModel();

            $data = [
                'title'    => 'Belum Absen ',
                'tanggal'  => $tanggal,
                'id_kelas' => $id_kelas,
                'kelas'    => $kelas->findAll(),
                'data'     => $presensi->getPresensiHarian($tanggal, $id_kelas)
            ];

            return view('admin/laporan/kehadiran/rekbelumabsen', $data);
        }

//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Belum Absen  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄









//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Belum Absen  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄


        public function dasTerlambat()
{
    $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
    $id_kelas = $this->request->getGet('kelas') ?? null;

    $presensi = new \App\Models\PresensiModel();
    $kelas    = new \App\Models\KelasModel();

    // Ambil data semua siswa sesuai kelas & tanggal
    $data = $presensi->getPresensiHarian($tanggal, $id_kelas);

    // Filter hanya yang datang terlambat
    $limitJam = '07:00';
    $data = array_filter($data, function($r) use ($limitJam) {
        return !empty($r['jam_masuk']) && $r['jam_masuk'] > $limitJam;
    });

    // Urutkan berdasarkan kelas lalu nama siswa
    usort($data, function($a, $b){
        if($a['kelas'] === $b['kelas']){
            return strcmp($a['nama_siswa'], $b['nama_siswa']);
        }
        return strcmp($a['kelas'], $b['kelas']);
    });

    $viewData = [
        'title'    => 'SISWA TERLAMBAT',
        'tanggal'  => $tanggal,
        'id_kelas' => $id_kelas,
        'kelas'    => $kelas->findAll(),
        'data'     => $data,
    ];

    return view('admin/laporan/kehadiran/siswaterlambat', $viewData);
}


//🔄 🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇🥇  – Belum Absen  🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄🔄


        public function dastidaksholat()
    {
        $tanggal  = $this->request->getGet('tanggal') ?? date('Y-m-d');
        $id_kelas = $this->request->getGet('kelas');

        $presensi = new PresensiModel();
        $kelas    = new KelasModel();

        $data = [
            'title'    => 'LAPORAN PRESENSI HARIAN',
            'tanggal'  => $tanggal,
            'id_kelas' => $id_kelas,
            'kelas'    => $kelas->findAll(),
            'data'     => $presensi->getPresensiHarian($tanggal, $id_kelas)
        ];

        return view('admin/laporan/kehadiran/siswatidaksholat', $data);
    }


}
