<?php

namespace App\Controllers\Admin\laporan\kehadiran;

use App\Controllers\BaseController;
use App\Models\LaporanPresensiModel;
use App\Models\LaporanKelasModel;

class ControllerLaporanBulanan extends BaseController
{
    protected $presensiModel;
    protected $kelasModel;

    public function __construct()
    {
        $this->presensiModel = new LaporanPresensiModel();
        $this->kelasModel    = new LaporanKelasModel();
    }

    public function index()
    {
        $bulan   = $this->request->getGet('bulan') ?? date('Y-m');
        $idKelas = $this->request->getGet('kelas');

        $kelas = $this->kelasModel->findAll();

        $builder = $this->presensiModel
            ->select("
                tb_siswa.id_siswa,
                tb_siswa.nis,
                tb_siswa.nama_siswa,
                tb_siswa.jk AS jenis_kelamin,
                tb_kelas.kelas,

                /* HADIR */
                SUM(
                    CASE 
                        WHEN tb_presensi_siswa.jam_masuk IS NOT NULL 
                             AND tb_presensi_siswa.jam_masuk != '-' 
                        THEN 1 ELSE 0 
                    END
                ) AS hadir,

                /* ALPHA */
                SUM(
                    CASE 
                        WHEN tb_presensi_siswa.jam_masuk IS NULL 
                             OR tb_presensi_siswa.jam_masuk = '-' 
                        THEN 1 ELSE 0 
                    END
                ) AS alpha,

                /* DUHUR */
                SUM(
                    CASE 
                        WHEN tb_presensi_siswa.jam_sholat IS NOT NULL 
                             AND tb_presensi_siswa.jam_sholat != '-' 
                        THEN 1 ELSE 0 
                    END
                ) AS duhur,

                /* FIX AGAR VIEW TIDAK ERROR */
                0 AS sakit,
                0 AS izin
            ")
            ->join('tb_siswa', 'tb_siswa.id_siswa = tb_presensi_siswa.id_siswa')
            ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
            ->where("DATE_FORMAT(tb_presensi_siswa.tanggal,'%Y-%m')", $bulan);

        if ($idKelas) {
            $builder->where('tb_siswa.id_kelas', $idKelas);
        }

        $data = $builder
            ->groupBy('tb_siswa.id_siswa')
            ->orderBy('tb_siswa.nama_siswa', 'ASC')
            ->findAll();

        return view('admin/laporan/kehadiran/rekbulanan', [
            'title'    => 'Laporan Presensi Bulanan',
            'data'     => $data,
            'kelas'    => $kelas,
            'bulan'    => $bulan,
            'id_kelas' => $idKelas
        ]);
    }

    public function exportExcel()
{
    $bulan   = $this->request->getGet('bulan') ?? date('Y-m');
    $idKelas = $this->request->getGet('kelas');

    $builder = $this->presensiModel
        ->select("
            tb_siswa.nis,
            tb_siswa.nama_siswa,
            tb_siswa.jk AS jenis_kelamin,
            tb_kelas.kelas,

            SUM(
                CASE 
                    WHEN tb_presensi_siswa.jam_masuk IS NOT NULL 
                         AND tb_presensi_siswa.jam_masuk != '-' 
                    THEN 1 ELSE 0 
                END
            ) AS hadir,

            SUM(
                CASE 
                    WHEN tb_presensi_siswa.jam_masuk IS NULL 
                     OR tb_presensi_siswa.jam_masuk = '-' 
                    THEN 1 ELSE 0 
                END
            ) AS alpha,

            SUM(
                CASE 
                    WHEN tb_presensi_siswa.jam_sholat IS NOT NULL 
                         AND tb_presensi_siswa.jam_sholat != '-' 
                    THEN 1 ELSE 0 
                END
            ) AS duhur
        ")
        ->join('tb_siswa', 'tb_siswa.id_siswa = tb_presensi_siswa.id_siswa')
        ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
        ->where("DATE_FORMAT(tb_presensi_siswa.tanggal,'%Y-%m')", $bulan);

    if ($idKelas) {
        $builder->where('tb_siswa.id_kelas', $idKelas);
    }

    $data = $builder
        ->groupBy('tb_siswa.id_siswa')
        ->orderBy('tb_siswa.nama_siswa', 'ASC')
        ->findAll();

    // ================= HEADER EXCEL =================
    $filename = 'laporan-presensi-'.$bulan.'.xls';

    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=\"$filename\"");
    header("Pragma: no-cache");
    header("Expires: 0");

    // ================= OUTPUT TABLE =================
    echo "<table border='1'>";
    echo "<tr>
            <th colspan='8'>LAPORAN PRESENSI BULANAN</th>
          </tr>";
    echo "<tr>
            <th colspan='8'>Bulan: ".date('F Y', strtotime($bulan.'-01'))."</th>
          </tr>";

    echo "<tr>
            <th>No</th>
            <th>NIS</th>
            <th>Nama</th>
            <th>JK</th>
            <th>Kelas</th>
            <th>Hadir</th>
            <th>Alpha</th>
            <th>Duhur</th>
          </tr>";

    $no = 1;
    foreach ($data as $r) {
        echo "<tr>
                <td>{$no}</td>
                <td>{$r['nis']}</td>
                <td>{$r['nama_siswa']}</td>
                <td>{$r['jenis_kelamin']}</td>
                <td>{$r['kelas']}</td>
                <td>{$r['hadir']}</td>
                <td>{$r['alpha']}</td>
                <td>{$r['duhur']}</td>
              </tr>";
        $no++;
    }

    echo "</table>";
    exit;
}

}
