<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Models\Menus\MenusModel;

abstract class BaseController extends Controller
{
    protected $request;
    protected $helpers = [];
    protected $session;
    protected $generalSettings;
    protected $menuModel;

    public function initController(
        RequestInterface $request,
        ResponseInterface $response,
        LoggerInterface $logger
    ) {
        parent::initController($request, $response, $logger);

        // Load session
        $this->session = \Config\Services::session();

        // General settings
        $this->generalSettings = (object) [
            'nama_sekolah' => 'SMAN 1 Cikatomas',
            'tahun_ajaran' => '2026',
            'school_year'  => '2026',
            'alamat'       => 'Cikatomas, Kabupaten Tasikmalaya',
            'copyright'    => '2026 SMAN 1 Cikatomas'
        ];

        // Menu model
        $this->menuModel = new MenusModel();

        // Role user
        $role = (int) (user()->role_id ?? user()->is_superadmin ?? 0);

        // Ambil semua menu aktif
        $allMenus = $this->menuModel->getSidebarMenus();

        // Filter menu sesuai role
        $menus = [];
        foreach ($allMenus as $m) {
            $roles = array_map('intval', explode(',', $m['roles']));
            if (in_array($role, $roles)) {
                $menus[] = $m;
            }
        }

        // Share ke semua view
        \Config\Services::renderer()->setData([
            'sidebarMenus'    => $menus,
            'generalSettings' => $this->generalSettings
        ]);
    }
}
