<?php

namespace App\Controllers;

use CodeIgniter\I18n\Time;
use App\Models\SiswaModel;
use App\Models\PresensiSiswaModel;
use App\Libraries\enums\TipeUser;
use App\Models\Jam\JamPresensiModel;


class Scan extends BaseController
{
    private bool $WANotificationEnabled;

    protected SiswaModel $siswaModel;
    protected PresensiSiswaModel $presensiSiswaModel;
    
    public function __construct()
    {
        $this->jamPresensiModel = new JamPresensiModel();

        $this->WANotificationEnabled = getenv('WA_NOTIFICATION') === 'true';

        $this->siswaModel = new SiswaModel();
        $this->presensiSiswaModel = new PresensiSiswaModel();
    }

    public function index($t = 'Masuk')
    {
        $data = ['waktu' => $t, 'title' => ''];
        return view('scan/scan', $data);
    }

    public function cekKode()
    {
        $uniqueCode = $this->request->getVar('unique_code');
        $waktuAbsen = $this->request->getVar('waktu');

        $type = TipeUser::Siswa;
        $result = $this->siswaModel->cekSiswa($uniqueCode);

        if (empty($result)) {
            $result = $this->guruModel->cekGuru($uniqueCode);
            if (!empty($result)) $type = TipeUser::Guru;
            else return $this->showErrorView('Data tidak ditemukan');
        }

        switch (strtolower($waktuAbsen)) {
            case 'masuk':  return $this->absenMasuk($type, $result);
            case 'pulang': return $this->absenPulang($type, $result);
            case 'duhur':  return $this->absenDuhur($type, $result);
            default: return $this->showErrorView('Waktu absen tidak valid');
        }
    }

    /* =====================================================
     * 🔐 CEK WAKTU PRESENSI (BARU – AMAN)
     * ===================================================== */
    private function cekWaktuPresensi(string $jenis)
{
    date_default_timezone_set('Asia/Jakarta');

    $jam = $this->jamPresensiModel->getJamAktif($jenis);

    if (!$jam) {
        return $this->showErrorView(
            '⛔ Jam presensi ' . strtoupper($jenis) . ' belum disetting admin'
        );
    }

    $sekarang = date('H:i:s');

    if ($sekarang < $jam['jam_mulai'] || $sekarang > $jam['jam_selesai']) {
        return $this->showErrorView(
            '⛔ Absensi ' . strtoupper($jenis) .
            ' hanya jam ' . substr($jam['jam_mulai'],0,5) .
            ' - ' . substr($jam['jam_selesai'],0,5)
        );
    }

    return true;
}


    // ================================
    // Presensi Masuk
    // ================================
    public function absenMasuk($type, $result)
    {
        $cekWaktu = $this->cekWaktuPresensi('masuk');
        if ($cekWaktu !== true) return $cekWaktu;

        $data['data'] = $result;
        $data['waktu'] = 'masuk';
        $date = Time::today()->toDateString();
        $time = Time::now()->toTimeString();

        switch ($type) {
            case TipeUser::Siswa:
                $id = $result['id_siswa'];
                $idKelas = $result['id_kelas'];
                $data['type'] = TipeUser::Siswa;

                $cek = $this->presensiSiswaModel->cekAbsen($id, $date);
                if ($cek)
                    return $this->showErrorView(
                        'Anda sudah absen hari ini',
                        ['presensi'=>$this->presensiSiswaModel->getPresensiById($cek)]
                    );

                $this->presensiSiswaModel->absenMasuk($id, $date, $time, $idKelas);
                $data['presensi'] = $this->presensiSiswaModel->getPresensiById($cek);
                break;
        }

        return view('scan/scan-result', $data);
    }

    // ================================
    // Presensi Pulang
    // ================================
    public function absenPulang($type, $result)
    {
        $cekWaktu = $this->cekWaktuPresensi('pulang');
        if ($cekWaktu !== true) return $cekWaktu;

        $data['data'] = $result;
        $data['waktu'] = 'pulang';
        $date = Time::today()->toDateString();
        $time = Time::now()->toTimeString();

        switch ($type) {
            case TipeUser::Siswa:
                $id = $result['id_siswa'];
                $data['type'] = TipeUser::Siswa;

                $cek = $this->presensiSiswaModel->cekAbsen($id, $date);
                if (!$cek)
                    return $this->showErrorView('Anda belum absen hari ini');

                $this->presensiSiswaModel->absenKeluar($cek, $time);
                $data['presensi'] = $this->presensiSiswaModel->getPresensiById($cek);
                break;
        }

        return view('scan/scan-result', $data);
    }

    // ================================
    // Presensi Sholat Duhur
    // ================================
    public function absenDuhur($type, $result)
    {
        $cekWaktu = $this->cekWaktuPresensi('duhur');
        if ($cekWaktu !== true) return $cekWaktu;

        $data['data'] = $result;
        $data['waktu'] = 'duhur';
        $date = Time::today()->toDateString();
        $time = Time::now()->toTimeString();

        switch ($type) {
            case TipeUser::Siswa:
                $id = $result['id_siswa'];
                $idKelas = $result['id_kelas'];
                $data['type'] = TipeUser::Siswa;

                $cek = $this->presensiSiswaModel->cekAbsenSolat($id, $date);
                if ($cek)
                    return $this->showErrorView(
                        'Absensi Sudah Berhasil Absen',
                        ['presensi'=>$this->presensiSiswaModel->getPresensiById($cek)]
                    );

                $this->presensiSiswaModel->absenSolat($id, $idKelas, $date, $time);
                $data['presensi'] = $this->presensiSiswaModel->getPresensiById($cek);
                break;
        }

        return view('scan/scan-result', $data);
    }

    public function showErrorView($msg='Terjadi kesalahan', $data=NULL)
    {
        $errdata = $data ?? [];
        $errdata['msg'] = $msg;
        return view('scan/error-scan-result', $errdata);
    }


public function izin()
{
    return view('scan/scan-izin', [
        'title' => 'Scan Izin Siswa',
        'waktu' => 'izin'
    ]);
}


public function cekIzin()
{
    $code = $this->request->getPost('unique_code');

    $siswa = $this->siswaModel->cekSiswa($code);
    if (!$siswa) {
        return view('scan/error-scan-result', [
            'msg' => 'QR tidak valid / siswa tidak ditemukan'
        ]);
    }

    return view('scan/izin-form-result', [
        'siswa' => $siswa
    ]);
}


public function simpanIzin()
{
    $izinModel = new \App\Models\Piket\IzinSiswaModel();

    $izinModel->insert([
        'id_siswa'  => $this->request->getPost('id_siswa'),
        'id_kelas'  => $this->request->getPost('id_kelas'),
        'tanggal'   => date('Y-m-d'),
        'jam'       => date('H:i:s'),
        'jenis'     => $this->request->getPost('jenis'),
        'keterangan'=> $this->request->getPost('keterangan'),
        'status'    => 'menunggu',
        'id_guru'   => session('id_guru')
    ]);

    return redirect()->to('/scan/izin')
        ->with('success', 'Izin berhasil dicatat');
}






}
