<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;

class Role implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        // =========================
        // Ambil user_id dari session
        // =========================
        $userId = session('logged_in'); // pakai key session kamu
        if (!$userId) {
            return redirect()->to('/login');
        }

        // =========================
        // Ambil role_id dari DB
        // =========================
        $db = db_connect();
        $user = $db->table('users u')
            ->select('u.id, u.role_id, r.slug')
            ->join('roles r', 'r.id = u.role_id', 'left')
            ->where('u.id', $userId)
            ->get()
            ->getRow();

        if (!$user) {
            return redirect()->to('/login');
        }

        $roleId = $user->role_id;

        // =========================
        // Ambil route yang sedang diakses
        // =========================
        $path = trim($request->getPath(), '/'); // hapus slash di awal/akhir

        // =========================
        // Cek di role_routes DB
        // =========================
        $route = $db->table('role_routes')
            ->where('route', $path)
            ->get()
            ->getRow();

        // Jika route tidak ada di DB, boleh akses
        if (!$route) {
            return; 
        }

        // =========================
        // Cek apakah role user termasuk allowed_roles
        // =========================
        $allowed = array_map('trim', explode(',', $route->allowed_roles)); // ['0','1','2','3']

        if (!in_array($roleId, $allowed)) {
            return redirect()->to('admin/access-denied');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // tidak dipakai
    }
}
