<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class RoleFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $role = (int) (user()->role_id ?? user()->is_superadmin ?? 0);

        if ($arguments) {
            $allowed = array_map('intval', $arguments);

            if (!in_array($role, $allowed)) {
                return redirect()->to('/admin/access-denied')
                    ->with('error', 'Akses ditolak');
            }
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // kosong
    }
}
