<?php

namespace App\Models;
use CodeIgniter\Model;

class DashboardModel extends Model
{
    protected $table = 'tb_presensi_siswa';

    public function rekapHarian($tanggal)
    {
        return $this->select('tb_kehadiran.kehadiran, COUNT(tb_presensi_siswa.id_presensi) as total')
            ->join('tb_kehadiran', 'tb_kehadiran.id_kehadiran = tb_presensi_siswa.id_kehadiran')
            ->where('tb_presensi_siswa.tanggal', $tanggal)
            ->groupBy('tb_presensi_siswa.id_kehadiran')
            ->findAll();
    }

    public function totalPresensiHariIni($tanggal)
    {
        return $this->where('tanggal', $tanggal)->countAllResults();
    }
}