<?php

namespace App\Models\Duhur;

use CodeIgniter\Model;

class HarianDuhurMod extends Model
{
    protected $table = 'tb_siswa';
    protected $primaryKey = 'id_siswa';

    /**
     * Ambil laporan sholat duhur per kelas & tanggal
     */
    public function getLaporan($idKelas, $tanggal)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('s.id_siswa, s.nis, s.nama_siswa, k.kelas AS nama_kelas, p.jam_sholat, p.tanggal')
            ->join('tb_kelas k', 's.id_kelas = k.id_kelas', 'left')
            ->join(
                "(SELECT id_presensi, id_siswa AS id_siswa_presensi, tanggal, jam_sholat 
                  FROM tb_presensi_siswa) p",
                "s.id_siswa = p.id_siswa_presensi AND p.tanggal = '$tanggal'",
                'left'
            )
            ->orderBy('s.nama_siswa', 'ASC');

        if ($idKelas) {
            $builder->where('s.id_kelas', $idKelas);
        }

        return $builder->get()->getResultArray();
    }
}
