<?php

namespace App\Models\Duhur;

use CodeIgniter\Model;

class RekapDuhurMod extends Model
{
    protected $table = 'tb_siswa';
    protected $primaryKey = 'id_siswa';

    /**
     * Ambil rekap sholat duhur per siswa per bulan
     * 
     * @param int $idKelas
     * @param string $bulan Format: YYYY-MM
     * @return array
     */
    public function getRekap($idKelas, $bulan)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('s.id_siswa, s.nis, s.nama_siswa, k.kelas AS nama_kelas, 
                      COUNT(p.id_presensi) AS hadir, 
                      (SELECT COUNT(*) FROM tb_presensi_siswa p2 
                       WHERE p2.id_siswa = s.id_siswa 
                       AND DATE_FORMAT(p2.tanggal, "%Y-%m") = "'.$bulan.'") AS total_hari')
            ->join('tb_kelas k', 's.id_kelas = k.id_kelas', 'left')
            ->join('tb_presensi_siswa p', 's.id_siswa = p.id_siswa AND DATE_FORMAT(p.tanggal, "%Y-%m") = "'.$bulan.'"', 'left');

        if ($idKelas) {
            $builder->where('s.id_kelas', $idKelas);
        }

        $builder->groupBy('s.id_siswa')
                ->orderBy('s.nama_siswa', 'ASC');

        return $builder->get()->getResultArray();
    }
}
