<?php

namespace App\Models\Duhur;

use CodeIgniter\Model;

class SiswaModel extends Model
{
    protected $table = 'tb_siswa';
    protected $primaryKey = 'id_siswa';

    protected $allowedFields = [
        'nis',
        'nama_siswa',
        'id_kelas',
        'jenis_kelamin',
        'no_hp',
        'unique_code'
    ];

    /**
     * ✅ TOTAL SISWA
     */
    public function totalSiswa()
    {
        return $this->countAllResults();
    }

    /**
     * ✅ DATA SISWA + KELAS
     */
    public function getSiswa()
    {
        return $this->db->table('tb_siswa s')
            ->select('s.nis, s.nama_siswa, s.jenis_kelamin, k.kelas')
            ->join('tb_kelas k', 'k.id_kelas = s.id_kelas')
            ->orderBy('s.nama_siswa', 'ASC')
            ->get()
            ->getResultArray();
    }


public function getSiswaByKelas($id_kelas = null)
{
    $builder = $this->db->table('tb_siswa s')
        ->select('s.nis, s.nama_siswa, s.jenis_kelamin, k.kelas')
        ->join('tb_kelas k', 'k.id_kelas = s.id_kelas');

    if ($id_kelas) {
        $builder->where('s.id_kelas', $id_kelas);
    }

    return $builder->orderBy('s.nama_siswa', 'ASC')
        ->get()
        ->getResultArray();
}

public function getSiswaWithKelas()
{
    return $this->db->table('tb_siswa s')
        ->select('s.id_siswa, s.nis, s.nama_siswa, k.kelas')
        ->join('tb_kelas k', 'k.id_kelas = s.id_kelas')
        ->orderBy('s.nama_siswa', 'ASC')
        ->get()->getResultArray();
}





}
