<?php

namespace App\Models\Jam;

use CodeIgniter\Model;

class JamPresensiModel extends Model
{
    protected $table = 'jam_presensi';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'jenis', 'jam_mulai', 'jam_selesai', 'aktif'
    ];

    public function getAll()
    {
        return $this->orderBy('jenis', 'ASC')->findAll();
    }


    public function getJamAktif(string $jenis)
{
    return $this->where('jenis', $jenis)
                ->where('aktif', 1)
                ->first();
}

}
