<?php

namespace App\Models\kehadiran;

use CodeIgniter\Model;

class PresensiModel extends Model
{
    protected $table = 'tb_presensi_siswa';
    protected $primaryKey = 'id_presensi';

    // =================== METODE EXISTING ===================

    public function countByKehadiran($status, $tanggal)
    {
        return $this->db->table('tb_presensi_siswa p')
            ->join('tb_kehadiran k', 'k.id_kehadiran = p.id_kehadiran')
            ->where('k.kehadiran', $status)
            ->where('p.tanggal', $tanggal)
            ->countAllResults();
    }

    public function countAlpha($tanggal)
    {
        return $this->db->table('tb_siswa s')
            ->whereNotIn('s.id_siswa', function ($builder) use ($tanggal) {
                return $builder->select('id_siswa')
                    ->from('tb_presensi_siswa')
                    ->where('tanggal', $tanggal);
            })
            ->countAllResults();
    }

    public function getPresensiHarian($tanggal, $id_kelas = null)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nis,
                s.nama_siswa,
                s.jenis_kelamin,
                k.kelas,
                p.jam_masuk,
                p.jam_keluar,
                kh.kehadiran,
                p.keterangan,
                p.jam_sholat
            ')
            ->join('tb_kelas k', 'k.id_kelas = s.id_kelas')
            ->join(
                'tb_presensi_siswa p',
                'p.id_siswa = s.id_siswa AND p.tanggal = "'.$tanggal.'"',
                'left'
            )
            ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left');

        if ($id_kelas) {
            $builder->where('s.id_kelas', $id_kelas);
        }

        return $builder->orderBy('s.nama_siswa', 'ASC')->get()->getResultArray();
    }

    public function getPresensiHarianPerBulan($bulan, $id_kelas = null)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nama_siswa,
                p.jam_sholat,
                kh.kehadiran
            ')
            ->join(
                'tb_presensi_siswa p',
                'p.id_siswa = s.id_siswa AND DATE_FORMAT(p.tanggal,"%Y-%m") = "'.$bulan.'"',
                'left'
            )
            ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left');

        if ($id_kelas) {
            $builder->where('s.id_kelas', $id_kelas);
        }

        return $builder->orderBy('s.nama_siswa', 'ASC')->get()->getResultArray();
    }

    public function getPresensiBulanan($bulan, $id_kelas = null)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nis,
                s.nama_siswa,
                k.kelas,
                SUM(CASE WHEN kh.kehadiran = "Hadir" THEN 1 ELSE 0 END) AS hadir,
                SUM(CASE WHEN kh.kehadiran = "Sakit" THEN 1 ELSE 0 END) AS sakit,
                SUM(CASE WHEN kh.kehadiran = "Izin"  THEN 1 ELSE 0 END) AS izin
            ')
            ->join('tb_kelas k', 'k.id_kelas = s.id_kelas')
            ->join(
                'tb_presensi_siswa p',
                'p.id_siswa = s.id_siswa AND DATE_FORMAT(p.tanggal,"%Y-%m")="'.$bulan.'"',
                'left'
            )
            ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left')
            ->groupBy('s.id_siswa');

        if ($id_kelas) {
            $builder->where('s.id_kelas', $id_kelas);
        }

        $result = $builder->get()->getResultArray();

        // Hitung alpha (total hari efektif - hadir/sakit/izin)
        foreach ($result as &$row) {
            $total_hari = $this->countHariEfektif($bulan);
            $row['alpha'] = $total_hari - ($row['hadir'] + $row['sakit'] + $row['izin']);
            if ($row['alpha'] < 0) $row['alpha'] = 0;
        }

        return $result;
    }

    public function countHariEfektif($bulan)
    {
        [$year, $month] = explode('-', $bulan);
        $today = date('Y-m-d');
        $endDate = date('Y-m-d', strtotime("$year-$month-01 last day of this month"));

        if (date('Y-m', strtotime($today)) === $bulan) {
            $endDate = $today;
        }

        $liburModel = new \App\Models\HariLiburModel();
        $hariLibur  = $liburModel->findColumn('tanggal');

        $start = new \DateTime("$year-$month-01");
        $end   = new \DateTime($endDate);

        $total = 0;
        while ($start <= $end) {
            $tanggal = $start->format('Y-m-d');
            $hari = $start->format('N');
            if ($hari < 6 && !in_array($tanggal, $hariLibur)) {
                $total++;
            }
            $start->modify('+1 day');
        }

        return $total;
    }

    public function getTotalPerSiswa($id_siswa, $bulan)
    {
        $builder = $this->db->table('tb_presensi_siswa p')
            ->select('
                SUM(CASE WHEN kh.kehadiran="Hadir" THEN 1 ELSE 0 END) AS hadir,
                SUM(CASE WHEN kh.kehadiran="Sakit" THEN 1 ELSE 0 END) AS sakit,
                SUM(CASE WHEN kh.kehadiran="Izin"  THEN 1 ELSE 0 END) AS izin
            ')
            ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left')
            ->where('p.id_siswa', $id_siswa)
            ->where('DATE_FORMAT(p.tanggal,"%Y-%m")', $bulan);

        $result = $builder->get()->getRowArray();
        $totalHari = $this->countHariEfektif($bulan);
        $result['alpha'] = $totalHari - ($result['hadir'] + $result['sakit'] + $result['izin']);
        return $result;
    }

    public function getLaporan($idKelas, $tanggal)
    {
        $builder = $this->db->table('tb_siswa s')
            ->select('
                s.id_siswa,
                s.nis,
                s.nama_siswa,
                k.kelas AS nama_kelas,
                p.jam_sholat,
                CASE WHEN p.jam_sholat IS NOT NULL THEN 1 ELSE 0 END AS status_sholat,
                kh.kehadiran
            ')
            ->join('tb_kelas k', 's.id_kelas = k.id_kelas', 'left')
            ->join(
                'tb_presensi_siswa p',
                'p.id_siswa = s.id_siswa AND p.tanggal = "'.$tanggal.'"',
                'left'
            )
            ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left')
            ->orderBy('s.nama_siswa', 'ASC');

        if ($idKelas) $builder->where('s.id_kelas', $idKelas);

        return $builder->get()->getResultArray();
    }

    
    public function getNamaSiswa($idSiswa)
    {
        $row = $this->db->table('tb_siswa')
            ->select('nama_siswa')
            ->where('id_siswa', $idSiswa)
            ->get()
            ->getRowArray();

        return $row['nama_siswa'] ?? '';
    }

    
// =================== HELPER TELAT ===================
private function isTelat($jamMasuk, $batas = '07:00')
{
    if (!$jamMasuk) return false;
    return strtotime($jamMasuk) > strtotime($batas);
}



public function getDetailHarian($idSiswa, $bulan)
{
    [$year, $month] = explode('-', $bulan);
    $start = new \DateTime("$year-$month-01");
    $end   = new \DateTime("$year-$month-01 last day of this month");

    $liburModel = new \App\Models\HariLiburModel();
    $hariLibur  = $liburModel->findColumn('tanggal');

    // ✅ AMBIL JAM MASUK & JAM KELUAR
    $presensi = $this->db->table('tb_presensi_siswa p')
        ->select('
            p.tanggal,
            kh.kehadiran,
            p.jam_masuk,
            p.jam_keluar,
            p.jam_sholat
        ')
        ->join('tb_kehadiran kh', 'kh.id_kehadiran = p.id_kehadiran', 'left')
        ->where('p.id_siswa', $idSiswa)
        ->where('DATE_FORMAT(p.tanggal,"%Y-%m")', $bulan)
        ->orderBy('p.tanggal', 'ASC')
        ->get()
        ->getResultArray();

    // Mapping presensi
    $mapPresensi = [];
    foreach ($presensi as $row) {
        $mapPresensi[$row['tanggal']] = [
            'status'     => $row['kehadiran'] ?? 'Alpa',
            'jam_masuk'  => $row['jam_masuk'] ?? null,
            'jam_keluar' => $row['jam_keluar'] ?? null,
            'jam_sholat' => $row['jam_sholat'] ?? null,
            'telat'      => ($row['kehadiran'] === 'Hadir')
                ? $this->isTelat($row['jam_masuk'])
                : false,
        ];
    }

    $detail = [];
    while ($start <= $end) {
        $tanggal = $start->format('Y-m-d');
        $hari    = $start->format('N');

        // Senin–Jumat & bukan hari libur
        if ($hari < 6 && !in_array($tanggal, $hariLibur)) {

            if (isset($mapPresensi[$tanggal])) {
                $data = $mapPresensi[$tanggal];
            } else {
                $data = [
                    'status'     => 'Alpa',
                    'jam_masuk'  => null,
                    'jam_keluar' => null,
                    'jam_sholat' => null,
                    'telat'      => false,
                ];
            }

            $detail[] = [
                'tanggal'    => $tanggal,
                'status'     => $data['status'],
                'jam_masuk'  => $data['jam_masuk'],
                'jam_keluar' => $data['jam_keluar'],
                'jam_sholat' => $data['jam_sholat'],
                'telat'      => $data['telat'],
            ];
        }

        $start->modify('+1 day');
    }

    return $detail;
}





















}
