<?php

namespace App\Models\Menus;

use CodeIgniter\Model;

class MenusModel extends Model
{
    protected $table         = 'menus';
    protected $primaryKey    = 'id';
    protected $returnType    = 'array';
    protected $allowedFields = [
        'label', 'icon', 'url', 'ctx', 'roles',
        'urutan', 'is_active', 'sidebar_color'
    ];

    public function getSidebarMenus()
    {
        return $this->where('is_active', 1)
                    ->orderBy('urutan', 'ASC')
                    ->findAll();
    }
}
