<?php

namespace App\Models\Pelanggaran;

use CodeIgniter\Model;

class PelanggaranSiswaModel extends Model
{
    protected $table = 'tb_pelanggaran';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'id_siswa', 'jenis_pelanggaran', 'poin',
        'keterangan', 'tanggal', 'id_guru'
    ];

    public function getAll()
    {
        return $this->select('tb_pelanggaran.*, tb_siswa.nama_siswa, tb_kelas.kelas')
            ->join('tb_siswa', 'tb_siswa.id_siswa = tb_pelanggaran.id_siswa')
            ->join('tb_kelas', 'tb_kelas.id_kelas = tb_siswa.id_kelas')
            ->orderBy('tanggal', 'DESC')
            ->findAll();
    }
}
