<?php

namespace App\Models;

use CodeIgniter\Model;

class PetugasModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';

    protected $allowedFields = [
        'email',
        'username',
        'password_hash',
        'is_superadmin',
        'active' // tambah field active supaya bisa login
    ];

    /**
     * Ambil semua data petugas
     */
    public function getAllPetugas()
    {
        return $this->findAll();
    }

    /**
     * Ambil data petugas berdasarkan ID
     */
    public function getPetugasById($id)
    {
        return $this->where([$this->primaryKey => $id])->first();
    }

    /**
     * Simpan data petugas
     * $idPetugas = null untuk insert, jika ada ID maka update
     */
    public function savePetugas($idPetugas, $email, $username, $passwordHash, $role)
    {
        return $this->save([
            $this->primaryKey => $idPetugas,
            'email' => $email,
            'username' => $username,
            'password_hash' => $passwordHash,
            'is_superadmin' => $role, // simpan sesuai pilihan role
            'active' => 1 // aktifkan akun supaya bisa login
        ]);
    }
}
