<?php

namespace App\Models\Piket;

use CodeIgniter\Model;

class IzinSiswaModel extends Model
{
    protected $table      = 'tb_izin_siswa';
    protected $primaryKey = 'id_izin';

    protected $allowedFields = [
        'id_siswa',
        'id_kelas',    // tambahkan
        'tanggal',
        'jam',         // tambahkan
        'jenis',
        'keterangan',
        'bukti',
        'status',
        'id_guru'
    ];

    /**
     * Ambil data izin + nama siswa
     */

    
    public function getWithSiswa()
    {
        return $this->select(
                'tb_izin_siswa.*,
                tb_siswa.nama_siswa,
                tb_kelas.kelas'
            )
            ->join('tb_siswa', 'tb_siswa.id_siswa = tb_izin_siswa.id_siswa')
            ->join('tb_kelas', 'tb_kelas.id_kelas = tb_izin_siswa.id_kelas')
            ->orderBy('tb_izin_siswa.tanggal', 'DESC')
            ->findAll();
    }


    public function getWithSiswaById($id)
{
    return $this->select(
            'tb_izin_siswa.*,
             tb_siswa.nama_siswa,
             tb_siswa.nis,
             tb_kelas.kelas'
        )
        ->join('tb_siswa', 'tb_siswa.id_siswa = tb_izin_siswa.id_siswa')
        ->join('tb_kelas', 'tb_kelas.id_kelas = tb_izin_siswa.id_kelas')
        ->where('tb_izin_siswa.id_izin', $id)
        ->first();
}


}
