<?php

namespace App\Models;

use CodeIgniter\Model;

class RekapModel extends Model
{
    protected $table = 'presensi';

    public function getData($id_kelas, $tanggal)
    {
        return $this->db->table('presensi p')
            ->select('
                s.nama_siswa,
                s.jenis_kelamin,
                k.kelas,
                p.jam_masuk,
                p.jam_sholat,
                p.jam_keluar,
                p.kehadiran
            ')
            ->join('siswa s', 's.id = p.id_siswa')
            ->join('kelas k', 'k.id_kelas = s.id_kelas')
            ->where('s.id_kelas', $id_kelas)
            ->where('DATE(p.tanggal)', $tanggal)
            ->orderBy('s.nama_siswa', 'ASC')
            ->get()
            ->getResultArray();
    }
}
