<?php

namespace App\Models;

use CodeIgniter\Model;

class SiswaModel extends Model
{
   protected function initialize()
   {
      $this->allowedFields = [
         'nis',
         'nama_siswa',
         'id_kelas',
         'jenis_kelamin',
         'no_hp',
         'unique_code'
      ];
   }

   protected $table = 'tb_siswa';

   protected $primaryKey = 'id_siswa';

   public function cekSiswa(string $unique_code)
   {
      $this->join(
         'tb_kelas',
         'tb_kelas.id_kelas = tb_siswa.id_kelas',
         'LEFT'
      )->join(
         'tb_jurusan',
         'tb_jurusan.id = tb_kelas.id_jurusan',
         'LEFT'
      );
      return $this->where(['unique_code' => $unique_code])->first();
   }

   public function getSiswaById($id)
   {
      return $this->where([$this->primaryKey => $id])->first();
   }

   public function getAllSiswaWithKelas($kelas = null, $jurusan = null)
   {
      $query = $this->join(
         'tb_kelas',
         'tb_kelas.id_kelas = tb_siswa.id_kelas',
         'LEFT'
      )->join(
         'tb_jurusan',
         'tb_kelas.id_jurusan = tb_jurusan.id',
         'LEFT'
      );

      if (!empty($kelas) && !empty($jurusan)) {
         $query = $this->where(['kelas' => $kelas, 'jurusan' => $jurusan]);
      } else if (empty($kelas) && !empty($jurusan)) {
         $query = $this->where(['jurusan' => $jurusan]);
      } else if (!empty($kelas) && empty($jurusan)) {
         $query = $this->where(['kelas' => $kelas]);
      } else {
         $query = $this;
      }

      return $query->orderBy('nama_siswa')->findAll();
   }

   public function getSiswaByKelas($id_kelas)
   {
      return $this->join(
         'tb_kelas',
         'tb_kelas.id_kelas = tb_siswa.id_kelas',
         'LEFT'
      )
         ->join('tb_jurusan', 'tb_kelas.id_jurusan = tb_jurusan.id', 'left')
         ->where(['tb_siswa.id_kelas' => $id_kelas])
         ->orderBy('nama_siswa')
         ->findAll();
   }

               public function createSiswa($nis, $nama, $idKelas, $jenisKelamin, $noHp)
               {
            return $this->save([
               'nis' => $nis,
               'nama_siswa' => $nama,
               'id_kelas' => $idKelas,
               'jenis_kelamin' => $jenisKelamin,
               'no_hp' => $noHp,
               'unique_code' => $nis // ambil langsung dari NIS yang diinput
            ]);

   }


public function updateSiswa($id, $nis, $nama, $idKelas, $jenisKelamin, $noHp, $unique_code = null)
{
$data = [
    'nis' => $nis,
    'nama_siswa' => $nama,
    'id_kelas' => $idKelas,
    'jenis_kelamin' => $jenisKelamin,
    'no_hp' => $noHp,
    'unique_code' => $nis // ambil langsung dari NIS
];


    if ($unique_code !== null) {
        $data['unique_code'] = $unique_code;
    }

    return $this->save(array_merge([$this->primaryKey => $id], $data));
}

















   public function getSiswaCountByKelas($kelasId)
   {
      $tree = array();
      $kelasId = cleanNumber($kelasId);
      if (!empty($kelasId)) {
         array_push($tree, $kelasId);
      }

      $kelasIds = $tree;
      if (countItems($kelasIds) < 1) {
         return array();
      }

      return $this->whereIn('tb_siswa.id_kelas', $kelasIds, false)->countAllResults();
   }

   // //generate CSV object
   // public function generateCSVObject($filePath)
   // {
   //    $array = array();
   //    $fields = array();
   //    $txtName = uniqid() . '.txt';
   //    $i = 0;
   //    $handle = fopen($filePath, 'r');
   //    if ($handle) {
   //       while (($row = fgetcsv($handle)) !== false) {
   //          if (empty($fields)) {
   //             $fields = $row;
   //             continue;
   //          }
   //          foreach ($row as $k => $value) {
   //             $array[$i][$fields[$k]] = $value;
   //          }
   //          $i++;
   //       }
   //       if (!feof($handle)) {
   //          return false;
   //       }
   //       fclose($handle);
   //       if (!empty($array)) {
   //          $txtFile = fopen(FCPATH . 'uploads/tmp/' . $txtName, 'w');
   //          fwrite($txtFile, serialize($array));
   //          fclose($txtFile);
   //          $obj = new \stdClass();
   //          $obj->numberOfItems = countItems($array);
   //          $obj->txtFileName = $txtName;
   //          @unlink($filePath);
   //          return $obj;
   //       }
   //    }
   //    return false;
   // }

// public function generateCSVObject($filePath)
// {
//     $handle = fopen($filePath, "r");
//     if ($handle === false) {
//         return false;
//     }

//     // ambil HEADER CSV
//     $header = fgetcsv($handle);
//     if (!$header) {
//         fclose($handle);
//         return false;
//     }

//     $rows = [];
//     while (($row = fgetcsv($handle)) !== false) {
//         if (count($row) !== count($header)) {
//             continue;
//         }
//         $rows[] = array_combine($header, $row);
//     }
//     fclose($handle);

//     if (empty($rows)) {
//         return false;
//     }

//     $txtName = uniqid('siswa_', true) . '.txt';
//     file_put_contents(
//         FCPATH . 'uploads/tmp/' . $txtName,
//         serialize($rows)
//     );

//     @unlink($filePath);

//     $obj = new \stdClass();
//     $obj->numberOfItems = count($rows);
//     $obj->txtFileName   = $txtName;
//     return $obj;
// }

public function generateCSVObject($filePath)
{
    $handle = fopen($filePath, "r");
    if (!$handle) return false;

    // coba delimiter ;
    $header = fgetcsv($handle, 0, ';');
    if (count($header) === 1) {
        rewind($handle);
        $header = fgetcsv($handle, 0, ',');
    }

    // normalisasi header
    $header = array_map(function ($h) {
        return strtolower(str_replace(' ', '_', trim($h)));
    }, $header);

    $rows = [];
    while (($row = fgetcsv($handle, 0, ';')) !== false) {
        if (count($row) === 1) {
            $row = str_getcsv($row[0], ',');
        }
        if (count($row) !== count($header)) continue;
        $rows[] = array_combine($header, $row);
    }
    fclose($handle);

    if (empty($rows)) return false;

    $txtName = uniqid('siswa_', true) . '.txt';
    file_put_contents(FCPATH . 'uploads/tmp/' . $txtName, serialize($rows));
    @unlink($filePath);

    $obj = new \stdClass();
    $obj->numberOfItems = count($rows);
    $obj->txtFileName = $txtName;
    return $obj;
}





public function importCSVItem($txtFileName, $index)
{
    $filePath = FCPATH . 'uploads/tmp/' . $txtFileName;
    if (!file_exists($filePath)) {
        return null;
    }

    $rows = @unserialize(file_get_contents($filePath));
    if (empty($rows) || !isset($rows[$index - 1])) {
        return null;
    }

    $item = $rows[$index - 1];

    // 🔴 INI YANG BENAR (SESUAI HEADER NORMALISASI)
    $data = [
        'nis'           => trim($item['nis'] ?? ''),
        'nama_siswa'    => trim($item['nama_siswa'] ?? ''),
        'id_kelas'      => (int) ($item['id_kelas'] ?? 0),
        'jenis_kelamin' => trim($item['jenis_kelamin'] ?? ''),
        'no_hp'         => trim($item['no_hp'] ?? ''),
        'unique_code'   => trim($item['nis'] ?? ''),
    ];

    // validasi minimal
    if (
        $data['nis'] === '' ||
        $data['nama_siswa'] === '' ||
        $data['id_kelas'] === 0
    ) {
        return null;
    }

    if ($this->insert($data)) {
        return $data;
    }

    return null;
}



























   public function getSiswa($id)
   {
      return $this->where('id_siswa', cleanNumber($id))->get()->getRow();
   }

   //delete post
   public function deleteSiswa($id)
   {
      $siswa = $this->getSiswa($id);
      if (!empty($siswa)) {
         //delete siswa
         return $this->where('id_siswa', $siswa->id_siswa)->delete();
      }
      return false;
   }

   //delete multi post
   public function deleteMultiSelected($siswaIds)
   {
      if (!empty($siswaIds)) {
         foreach ($siswaIds as $id) {
            $this->deleteSiswa($id);
         }
      }
   }



   public function updateUniqueCode($id_siswa, $unique_code)
{
    return $this->update($id_siswa, [
        'unique_code' => $unique_code
    ]);
}

}
