<?php

namespace App\Models\Upload;

class JurusanModel extends BaseModel
{
    protected $builder;

    public function __construct()
    {
        parent::__construct();
        $this->builder = $this->db->table('tb_jurusan');
    }

    // =============================
    // TAMBAH DATA
    // =============================
    public function addJurusan($data)
    {
        return $this->builder->insert($data) ? 'success' : 'failed';
    }

    // =============================
    // EDIT DATA
    // =============================
    public function editJurusan($id, $data)
    {
        $id = cleanNumber($id);

        $jurusan = $this->getJurusan($id);

        if (empty($jurusan)) {
            return 'not_found';
        }

        // ❌ Tidak boleh edit jika sedang dipakai
        if ($this->isUsed($id)) {
            return 'used';
        }

        $update = $this->builder
            ->where('id', $id)
            ->update($data);

        return $update ? 'success' : 'failed';
    }

    // =============================
    // GET ALL
    // =============================
    public function getDataJurusan()
    {
        return $this->builder
            ->orderBy('id', 'ASC')
            ->get()
            ->getResultArray();
    }

    // =============================
    // GET BY ID
    // =============================
    public function getJurusan($id)
    {
        return $this->builder
            ->where('id', cleanNumber($id))
            ->get()
            ->getRow();
    }

    // =============================
    // CEK APAKAH DIPAKAI TABEL LAIN
    // =============================
    public function isUsed($id)
    {
        $id = cleanNumber($id);

        $jurusan = $this->getJurusan($id);
        if (empty($jurusan)) {
            return false;
        }

        $relations = [
            'tb_siswa' => ['id_jurusan'],
            'tb_kelas' => ['id_jurusan'],
        ];

        foreach ($relations as $table => $columns) {

            $fields = $this->db->getFieldNames($table);

            foreach ($columns as $col) {

                if (in_array($col, $fields)) {

                    $count = $this->db->table($table)
                        ->where($col, $id)
                        ->countAllResults();

                    if ($count > 0) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    // =============================
    // DELETE DATA
    // =============================
    public function deleteJurusan($id)
    {
        $jurusan = $this->getJurusan($id);

        if (empty($jurusan)) {
            return 'not_found';
        }

        if ($this->isUsed($id)) {
            return 'used';
        }

        return $this->builder
            ->where('id', $id)
            ->delete() ? 'success' : 'failed';
    }





    public function isDuplicate($nama, $excludeId = null)
{
    $this->builder->where('UPPER(jurusan)', strtoupper($nama));

    if ($excludeId !== null) {
        $this->builder->where('id !=', $excludeId);
    }

    return $this->builder->countAllResults() > 0;
}

}
